/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.qlangtech.tis.plugin.IdentityName;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public interface DBIdentity
extends IdentityName {
    public static final String KEY_DB_NAME = "dsname";
    public static final String KEY_TYPE = "type";
    public static final String KEY_UPDATE = "update";

    public static DBIdentity parseId(String idVal) {
        Optional<DBIdentity> id = DBIdentity.parse(idVal);
        if (!id.isPresent()) {
            throw new IllegalStateException("id must be present:" + idVal);
        }
        return id.get();
    }

    public static Optional<DBIdentity> parse(final String idVal) {
        if (StringUtils.isEmpty((String)idVal)) {
            return Optional.empty();
        }
        return Optional.of(new DBIdentity(){

            public String identityValue() {
                return idVal;
            }
        });
    }

    default public boolean isEquals(DBIdentity queryDBSourceId) {
        return StringUtils.equals((String)Objects.requireNonNull(queryDBSourceId.identityValue(), "dbFactoryId can not be null"), (String)this.identityValue());
    }
}

