/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.google.common.base.Joiner;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.ReservedFieldType;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ColumnMetaData
extends Option
implements IColMetaGetter {
    public static final String KEY_COLS_METADATA = "cols-metadata";
    private final String key;
    private final DataType type;
    private final int index;
    private ReservedFieldType schemaFieldType;
    private final boolean pk;
    private final boolean nullable;
    private transient String comment;

    public static Map<String, ColumnMetaData> toMap(List<ColumnMetaData> cols) {
        TreeMap<String, ColumnMetaData> result = new TreeMap<String, ColumnMetaData>(String.CASE_INSENSITIVE_ORDER);
        result.putAll(cols.stream().collect(Collectors.toMap(c -> c.getName(), c -> c)));
        return result;
    }

    public static StringBuffer buildExtractSQL(String tableName, List<ColumnMetaData> cols) {
        return ColumnMetaData.buildExtractSQL(tableName, false, cols);
    }

    public static CMeta convert(ColumnMetaData c) {
        return c.convert();
    }

    public static List<ColumnMetaData> convert(List<CMeta> cs) {
        int[] index = new int[1];
        return cs.stream().map(cm -> {
            int n = index[0];
            index[0] = n + 1;
            return new ColumnMetaData(n, cm.getName(), cm.getType(), cm.isPk(), cm.isNullable());
        }).collect(Collectors.toList());
    }

    public static void fillSelectedTabMeta(ISelectedTab tab, Function<ISelectedTab, Map<String, ColumnMetaData>> tableColsMetaGetter) {
        Map<String, ColumnMetaData> colsMeta = tableColsMetaGetter.apply(tab);
        ColumnMetaData colMeta = null;
        if (colsMeta.size() < 1) {
            throw new IllegalStateException("table:" + tab.getName() + " relevant cols meta can not be null");
        }
        List<CMeta> cols = tab.getCols();
        for (CMeta col : cols) {
            colMeta = colsMeta.get(col.getName());
            if (colMeta == null) continue;
            col.setPk(colMeta.isPk());
            col.setType(colMeta.getType());
            col.setComment(colMeta.getComment());
            col.setNullable(colMeta.isNullable());
        }
    }

    public static StringBuffer buildExtractSQL(String tableName, boolean useAlias, List<ColumnMetaData> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            throw new IllegalStateException("tableName:" + tableName);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(Joiner.on((String)",").join(cols.stream().map(r -> {
            if (useAlias) {
                return "a." + r.getKey();
            }
            return r.getKey();
        }).iterator())).append("\n");
        sql.append("FROM ").append(tableName);
        if (useAlias) {
            sql.append(" AS a");
        }
        return sql;
    }

    public ColumnMetaData(int index, String key, DataType type, boolean pk, boolean nullable) {
        super(key, key);
        this.pk = pk;
        this.key = key;
        this.type = type;
        this.index = index;
        this.nullable = nullable;
    }

    public ColumnMetaData(int index, String key, DataType type, boolean pk) {
        this(index, key, type, pk, !pk);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ReservedFieldType getSchemaFieldType() {
        return this.schemaFieldType;
    }

    public void setSchemaFieldType(ReservedFieldType schemaFieldType) {
        this.schemaFieldType = schemaFieldType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public int getIndex() {
        return this.index;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isPk() {
        return this.pk;
    }

    private CMeta convert() {
        ColumnMetaData c = this;
        CMeta cmeta = this.createCmeta();
        cmeta.setName(c.getName());
        cmeta.setComment(c.getComment());
        cmeta.setPk(c.isPk());
        cmeta.setType(c.getType());
        cmeta.setNullable(c.isNullable());
        return cmeta;
    }

    protected CMeta createCmeta() {
        return new CMeta();
    }

    public String toString() {
        return "ColumnMetaData{key='" + this.key + "', type=" + this.type + ", index=" + this.index + ", schemaFieldType=" + this.schemaFieldType + ", pk=" + this.pk + "}";
    }
}

