/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.DataTypeMeta;
import com.qlangtech.tis.plugin.ds.ElementCreatorFactory;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.plugin.ds.IMultiElement;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import com.qlangtech.tis.plugin.ds.TypeBase;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class CMeta
extends TypeBase
implements Serializable,
IColMetaGetter,
IdentityName {
    public static final String FIELD_NAME = "name";
    public static final String KEY_COLUMN_SIZE = "columnSize";
    public static final String KEY_DECIMAL_DIGITS = "decimalDigits";
    private String name;
    public static final String KEY_ELEMENT_CREATOR_FACTORY = "elementCreator";
    private Boolean pk = false;
    private String comment;
    private boolean nullable;
    private boolean disable = false;

    @Override
    public String getName() {
        return this.name;
    }

    public static DataType parseType(JSONObject targetCol, BiConsumer<String, String> errorProcess) {
        boolean hasError = false;
        JSONObject type = null;
        type = Objects.requireNonNull(targetCol, "targetCol can not be null").getJSONObject("type");
        if (type == null) {
            errorProcess.accept(FIELD_NAME, "\u5fc5\u987b\u586b\u5199");
            return null;
        }
        Integer jdbcType = type.getInteger("type");
        DataTypeMeta typeMeta = DataTypeMeta.getDataTypeMeta((JDBCTypes)JDBCTypes.parse((int)jdbcType));
        Integer colSize = 0;
        colSize = type.getInteger(KEY_COLUMN_SIZE);
        if (colSize == null && typeMeta.isContainColSize()) {
            errorProcess.accept(KEY_COLUMN_SIZE, "\u5fc5\u987b\u586b\u5199");
            hasError = true;
        }
        Integer decimalDigits = 0;
        decimalDigits = type.getInteger(KEY_DECIMAL_DIGITS);
        if (decimalDigits == null && typeMeta.isContainDecimalRange()) {
            errorProcess.accept(KEY_DECIMAL_DIGITS, "\u5fc5\u987b\u586b\u5199");
            hasError = true;
        }
        if (hasError) {
            return null;
        }
        DataType dataType = DataType.create((Integer)jdbcType, (String)type.getString("typeName"), (Integer)colSize);
        dataType.setDecimalDigits(decimalDigits);
        return dataType;
    }

    public static CMeta create(String colName, JDBCTypes type) {
        return CMeta.create(Optional.empty(), colName, type);
    }

    public static CMeta create(Optional<ElementCreatorFactory<CMeta>> elementCreator, String colName, JDBCTypes type) {
        return CMeta.create(elementCreator, colName, DataTypeMeta.getDataTypeMeta((JDBCTypes)type).getType());
    }

    public static CMeta create(Optional<ElementCreatorFactory<CMeta>> elementCreator, String colName, DataType type) {
        CMeta cmeta = elementCreator.map(factory -> (CMeta)factory.createDefault(new JSONObject())).orElseGet(() -> new CMeta());
        cmeta.setName(colName);
        cmeta.setType(type);
        return cmeta;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public String identityValue() {
        return this.getName();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isPk() {
        return this.pk;
    }

    public void setPk(Boolean pk) {
        if (pk == null) {
            return;
        }
        this.pk = pk;
    }

    public void setName(String name) {
        if (StringUtils.indexOf((String)name, (String)"{") > -1) {
            throw new IllegalArgumentException("illegal param name:" + name);
        }
        this.name = name;
    }

    public String toString() {
        return "{name='" + this.getName() + "', type=" + this.getType() + "}";
    }

    @JSONField(serialize=false)
    public Class<?> getDescribleClass() {
        return super.getDescribleClass();
    }

    public static class VirtualCMeta
    extends CMeta {
        public final boolean isVirtual() {
            return true;
        }
    }

    public static class ParsePostMCols<T extends IMultiElement> {
        public List<T> writerCols = Lists.newArrayList();
        public boolean validateFaild = false;
        public boolean pkHasSelected = false;
    }

    public static interface INestCMetaGetter {
        public <T extends CMeta> List<T> nestCols();
    }
}

