/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.google.common.collect.Lists;
import com.qlangtech.tis.manage.common.Option;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TisUTF8 {
    public static void main(String[] args) {
        Charset big5 = Charset.forName("big5");
        System.out.println(big5);
        List<Option> all = TisUTF8.allSupported();
        for (Option o : all) {
            System.out.println(o.getName() + ":" + o.getValue());
        }
    }

    public static List<Option> allSupported() {
        ArrayList all = Lists.newArrayList();
        Option o = null;
        for (Map.Entry<String, Charset> entry : Charset.availableCharsets().entrySet()) {
            if (entry.getKey().startsWith("x-") || entry.getKey().startsWith("IBM") || entry.getKey().startsWith("windows-") || entry.getKey().startsWith("ISO-")) continue;
            o = new Option(entry.getKey(), StringUtils.lowerCase((String)entry.getKey()));
            all.add(o);
        }
        return all;
    }

    private TisUTF8() {
    }

    public static Charset get() {
        return StandardCharsets.UTF_8;
    }

    public static String getName() {
        return TisUTF8.get().name();
    }
}

