/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

public class TimeFormatter {
    private static TimeFormatter instance;
    private String hourSuffix = null;
    private String hoursSuffix = null;
    private String minuteSuffix = null;
    private String minutesSuffix = null;
    private String secondSuffix = null;
    private String secondsSuffix = null;

    private TimeFormatter() {
        this(" hour", " hours", " minute", " minutes", " second", " seconds");
    }

    private TimeFormatter(String hourSuffix, String hoursSuffix, String minuteSuffix, String minutesSuffix, String secondSuffix, String secondsSuffix) {
        this.hourSuffix = hourSuffix;
        this.hoursSuffix = hoursSuffix;
        this.minuteSuffix = minuteSuffix;
        this.minutesSuffix = minutesSuffix;
        this.secondSuffix = secondSuffix;
        this.secondsSuffix = secondsSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String formatTime(long timeMillis) {
        if (instance != null) return instance.formatTime(timeMillis / 1000L, true);
        Class<TimeFormatter> clazz = TimeFormatter.class;
        synchronized (TimeFormatter.class) {
            if (instance != null) return instance.formatTime(timeMillis / 1000L, true);
            instance = new TimeFormatter();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return instance.formatTime(timeMillis / 1000L, true);
        }
    }

    public String formatTime(long seconds, boolean useUnicodeChars) {
        int hours = 0;
        if (seconds > 3600L) {
            hours = (int)seconds / 3600;
            seconds -= (long)hours * 3600L;
        }
        int mins = (int)seconds / 60;
        seconds -= (long)mins * 60L;
        if (hours > 0) {
            if (mins > 45) {
                return hours + 1 + this.hourSuffix;
            }
            if (mins > 30) {
                if (useUnicodeChars) {
                    return hours + "\u00be" + this.hoursSuffix;
                }
                return hours + " 3/4" + this.hoursSuffix;
            }
            if (mins > 15) {
                if (useUnicodeChars) {
                    return hours + "\u00bd" + this.hoursSuffix;
                }
                return hours + " 1/2" + this.hoursSuffix;
            }
            if (mins > 0) {
                if (useUnicodeChars) {
                    return hours + "\u00bc" + this.hoursSuffix;
                }
                return hours + " 1/4" + this.hoursSuffix;
            }
            return hours + " hour" + (hours > 1 ? "s" : "");
        }
        if (mins > 0) {
            if (seconds > 45L) {
                return mins + 1 + this.minutesSuffix;
            }
            if (seconds > 30L) {
                if (useUnicodeChars) {
                    return mins + "\u00be" + this.minutesSuffix;
                }
                return mins + " 3/4" + this.minutesSuffix;
            }
            if (seconds > 15L) {
                if (useUnicodeChars) {
                    return mins + "\u00bd" + this.minutesSuffix;
                }
                return mins + " 1/2" + this.minutesSuffix;
            }
            if (seconds > 0L) {
                if (useUnicodeChars) {
                    return mins + "\u00bc" + this.minutesSuffix;
                }
                return mins + " 1/4" + this.minutesSuffix;
            }
            return mins + (mins > 1 ? this.minutesSuffix : this.minuteSuffix);
        }
        return seconds + (seconds != 1L ? this.secondsSuffix : this.secondSuffix);
    }
}

