/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.qlangtech.tis.fs.IPath;
import com.qlangtech.tis.fs.ITISFileSystem;
import com.qlangtech.tis.fs.TISFSDataOutputStream;
import com.qlangtech.tis.manage.biz.dal.pojo.Snapshot;
import com.qlangtech.tis.manage.biz.dal.pojo.UploadResource;
import com.qlangtech.tis.manage.common.PropteryGetter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class SnapshotDomain {
    private UploadResource solrSchema = new UploadResource();
    private UploadResource solrConfig = new UploadResource();
    private final Snapshot snapshot;

    public SnapshotDomain() {
        this.snapshot = new Snapshot();
    }

    public SnapshotDomain(Snapshot snapshot) {
        if (snapshot == null) {
            throw new IllegalArgumentException("snapshot can not be null");
        }
        this.snapshot = snapshot;
    }

    public void writeResource2fs(ITISFileSystem fs, String coreName, PropteryGetter getter) {
        String path = getter.getFsPath(fs, coreName);
        IPath dst = fs.getPath(path);
        if (dst == null) {
            throw new IllegalStateException("path can not be create:" + path);
        }
        TISFSDataOutputStream dstoutput = null;
        try {
            dstoutput = fs.create(dst, true);
            IOUtils.write((byte[])getter.getContent(this), (OutputStream)dstoutput);
        }
        catch (IOException e1) {
            try {
                throw new RuntimeException("[ERROR] Submit Service Core  Schema.xml to HDFS Failure !!!!", e1);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(dstoutput);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)dstoutput);
    }

    public Integer getAppId() {
        return this.snapshot.getAppId();
    }

    public Snapshot getSnapshot() {
        if (this.snapshot == null) {
            throw new NullPointerException("this.snapshot can not be null");
        }
        return this.snapshot;
    }

    public void setSolrSchema(UploadResource solrSchema) {
        this.solrSchema = solrSchema;
    }

    public void setSolrConfig(UploadResource solrConfig) {
        this.solrConfig = solrConfig;
    }

    public UploadResource getSolrSchema() {
        return this.solrSchema;
    }

    public UploadResource getSolrConfig() {
        return this.solrConfig;
    }
}

