/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.alibaba.fastjson.JSON;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.PostFormStreamProcess;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.realtime.utils.NetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendSMSUtils {
    public static final Contact BAISUI_PHONE = new Contact(15868113480L, "baisui@qlangtech.com");
    private static final Logger logger = LoggerFactory.getLogger(SendSMSUtils.class);
    private static Map<Long, AtomicLong> lastSendSMSTimestampMap = new HashMap<Long, AtomicLong>();
    private static AtomicInteger errCount = new AtomicInteger(0);

    public static void send(String content, Contact ... contact) {
        if (!RunEnvironment.isOnlineMode()) {
            return;
        }
        errCount.incrementAndGet();
        for (Contact c : contact) {
            AtomicLong lastSendSMSTimestamp = lastSendSMSTimestampMap.get(c.moblie);
            if (lastSendSMSTimestamp != null) continue;
            lastSendSMSTimestamp = new AtomicLong();
            lastSendSMSTimestampMap.put(c.moblie, lastSendSMSTimestamp);
        }
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (Contact c : contact) {
            AtomicLong lastSendSMSTimestamp = lastSendSMSTimestampMap.get(c.moblie);
            long last = lastSendSMSTimestamp.get();
            if (last + 900000L >= System.currentTimeMillis() || !lastSendSMSTimestamp.compareAndSet(last, System.currentTimeMillis())) continue;
            contacts.add(c);
        }
        if (contacts.isEmpty()) {
            logger.info("send frequency is too high,ignore msg:" + content);
            return;
        }
        try {
            content = StringUtils.substring((String)("errs:" + errCount.get() + "|" + content), (int)0, (int)100);
            StringBuffer email = new StringBuffer();
            for (int i = 0; i < contacts.size(); ++i) {
                email.append(((Contact)contacts.get(i)).getEmail());
                if (i >= contacts.size() - 1) continue;
                email.append(";");
            }
            URL url = new URL("http://sm.xxxx-inc.com/sm-soa/sm/send_msg?msg=" + URLEncoder.encode("from:" + NetUtils.getHost() + "|" + content, TisUTF8.getName()) + "&tos=" + URLEncoder.encode(email.toString(), TisUTF8.getName()));
            logger.info("dingding url:" + url);
            ConfigFileContext.processContent(url, new ConfigFileContext.StreamProcess<Object>(){

                @Override
                public Object p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                    try {
                        System.out.println("receive dingding reply:" + IOUtils.toString((InputStream)stream, (Charset)TisUTF8.get()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
            if (contacts.size() < 1) {
                return;
            }
            StringBuffer phones = new StringBuffer();
            for (Contact c : contacts) {
                phones.append(c.getMoblie()).append(",");
            }
            url = new URL("http://sm.qlangtech.com/sm-soa/sm/send_note");
            logger.info("sms url:" + url);
            StringBuffer buffer = new StringBuffer();
            HashMap<String, String> paramString = new HashMap<String, String>();
            paramString.put("fromip", StringUtils.replace((String)NetUtils.getHost(), (String)".", (String)"-"));
            paramString.put("collection", "#");
            paramString.put("msg", content);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("code", "DS_21482144353");
            params.put("phones", phones.toString());
            params.put("param_string", URLEncoder.encode(JSON.toJSONString(paramString), "utf8"));
            params.put("ms_type", "1");
            params.put("send_time", "0");
            for (Map.Entry entry : params.entrySet()) {
                buffer.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
            }
            SendSMSUtils.applyRequest(url, buffer.toString().getBytes(Charset.forName("utf8")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        errCount.set(0);
        logger.info("send sms");
    }

    protected static void applyRequest(final URL url, byte[] content) {
        ConfigFileContext.processContent(url, content, new PostFormStreamProcess<Object>(){

            @Override
            public PostFormStreamProcess.ContentType getContentType() {
                return PostFormStreamProcess.ContentType.TEXT_HTML;
            }

            @Override
            public Object p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                try {
                    JSONObject result = new JSONObject(new JSONTokener(IOUtils.toString((InputStream)stream, (String)"utf8")));
                    if (result.getInt("code") != 1) {
                        logger.info("send_sms_msg faild url:" + url);
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static class Contact {
        private final long moblie;
        private final String email;

        public Contact(long moblie, String email) {
            this.moblie = moblie;
            this.email = email;
        }

        public long getMoblie() {
            return this.moblie;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

