/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.google.common.collect.Lists;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.TisUTF8;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.json.JSONObject;

public abstract class PostFormStreamProcess<T>
extends ConfigFileContext.StreamProcess<T> {
    public static final List<ConfigFileContext.Header> HEADERS_application_x_www_form_urlencoded = Collections.singletonList(new ConfigFileContext.Header("content-type", "application/x-www-form-urlencoded"));
    public static final List<ConfigFileContext.Header> HEADERS_multipart_byteranges = Collections.singletonList(new ConfigFileContext.Header("content-type", "multipart/byteranges"));
    public static final List<ConfigFileContext.Header> HEADERS_CONTENT_TYPE_JSON = Collections.singletonList(new ConfigFileContext.Header("Content-Type", "application/json"));
    public static final List<ConfigFileContext.Header> HEADER_TEXT_HTML = Lists.newArrayList((Object[])new ConfigFileContext.Header[]{new ConfigFileContext.Header("content-type", "text/html")});
    private final List<ConfigFileContext.Header> appendHeaders;

    public ContentType getContentType() {
        return ContentType.Application_x_www_form_urlencoded;
    }

    public PostFormStreamProcess(List<ConfigFileContext.Header> appendHeaders) {
        this.appendHeaders = appendHeaders;
    }

    public PostFormStreamProcess() {
        this(Collections.emptyList());
    }

    public PostFormStreamProcess(ConfigFileContext.Header appendHeader) {
        this(Collections.singletonList(appendHeader));
    }

    @Override
    public final List<ConfigFileContext.Header> getHeaders() {
        if (CollectionUtils.isEmpty(this.appendHeaders)) {
            return this.getContentType().headers;
        }
        ArrayList hds = Lists.newArrayList(this.getContentType().headers);
        hds.addAll(this.appendHeaders);
        return hds;
    }

    public int getMaxRetry() {
        return 1;
    }

    static interface ISerializeParams {
        public byte[] serializeParams(List<HttpUtils.PostParam> var1);
    }

    public static enum ContentType {
        Multipart_byteranges(HEADERS_multipart_byteranges, params -> {
            if (CollectionUtils.isNotEmpty((Collection)params)) {
                return params.stream().map(param -> {
                    try {
                        return param.getKey() + "=" + URLEncoder.encode(param.getValue(), TisUTF8.getName());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.joining("&")).getBytes(Charset.forName(TisUTF8.getName()));
            }
            return null;
        }),
        TEXT_HTML(HEADER_TEXT_HTML, ContentType.Multipart_byteranges.paramSerialize),
        Application_x_www_form_urlencoded(HEADERS_application_x_www_form_urlencoded, ContentType.Multipart_byteranges.paramSerialize),
        JSON(HEADERS_CONTENT_TYPE_JSON, params -> {
            JSONObject json = new JSONObject();
            for (HttpUtils.PostParam param : params) {
                json.put(param.getKey(), param.getRawVal());
            }
            return json.toString().getBytes(Charset.forName(TisUTF8.getName()));
        });

        private final List<ConfigFileContext.Header> headers;
        private final ISerializeParams paramSerialize;

        private ContentType(List<ConfigFileContext.Header> headers, ISerializeParams paramSerialize) {
            this.headers = headers;
            this.paramSerialize = paramSerialize;
        }

        public byte[] serializeParams(List<HttpUtils.PostParam> params) {
            return this.paramSerialize.serializeParams(params);
        }

        public List<ConfigFileContext.Header> getHeaders() {
            return this.headers;
        }
    }
}

