/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.plugin.IdentityName;
import java.util.List;
import java.util.Objects;

public class Option
implements IdentityName {
    public static final String KEY_VALUE = "val";
    public static final String KEY_LABEL = "label";
    private final String name;
    private final Object value;

    public static Option create(JSONObject option) {
        return new Option(Objects.requireNonNull(option, "option can not be null").getString(KEY_LABEL), option.getString(KEY_VALUE));
    }

    public static JSONArray toJson(List<?> options) {
        JSONArray enums = new JSONArray();
        if (options != null) {
            options.stream().map(o -> {
                if (o instanceof Option) {
                    return o;
                }
                if (o instanceof IdentityName) {
                    return new Option(((IdentityName)o).identityValue());
                }
                throw new IllegalStateException("illegal type:" + o.getClass());
            }).forEach(key -> {
                JSONObject o = new JSONObject();
                o.put(KEY_LABEL, (Object)((Option)key).getName());
                o.put(KEY_VALUE, ((Option)key).getValue());
                enums.add((Object)o);
            });
        }
        return enums;
    }

    public Option(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public Option(String val) {
        this(val, val);
    }

    public String identityValue() {
        return String.valueOf(this.value);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }
}

