/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class MockHttpURLConnection
extends HttpURLConnection {
    private final InputStream inputStream;
    private final Map<String, List<String>> headerFields;

    public MockHttpURLConnection(InputStream inputStream) {
        this(inputStream, Collections.emptyMap());
    }

    public MockHttpURLConnection(InputStream inputStream, Map<String, List<String>> headerFields) {
        super(null);
        if (inputStream == null) {
            throw new IllegalStateException("param inputStream can not be null");
        }
        this.inputStream = inputStream;
        this.headerFields = headerFields;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public void disconnect() {
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void connect() throws IOException {
    }
}

