/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.ajax.AjaxResult;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.MockConnectionMaker;
import com.qlangtech.tis.manage.common.MockHttpURLConnection;
import com.qlangtech.tis.manage.common.PostFormStreamProcess;
import com.qlangtech.tis.manage.common.TisUTF8;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    public static DefaultMockConnectionMaker mockConnMaker;

    public static void addMockGlobalParametersConfig() {
        HttpUtils.addMockApply(1, "global_parameters_config_action", "global_params.json");
    }

    public static void addMockApply(int order, String testStr, String classpath) {
        HttpUtils.addMockApply(order, testStr, classpath, HttpUtils.class);
    }

    public static CacheMockRes addMockApply(int order, String testStr, String classpath, Class<?> clazz) {
        return HttpUtils.addMockApply(order, testStr, (IClasspathRes)new ClasspathRes(order, classpath, clazz));
    }

    public static void addMockApply(String testStr, IClasspathRes classpathRes) {
        HttpUtils.addMockApply(-1, testStr, classpathRes);
    }

    public static CacheMockRes addMockApply(int orderIndex, MockMatchKey test, IClasspathRes classpathRes) {
        CacheMockRes cacheMockRes;
        if (mockConnMaker == null) {
            mockConnMaker = new DefaultMockConnectionMaker();
        }
        if ((cacheMockRes = HttpUtils.mockConnMaker.resourceStore.get(test)) == null) {
            cacheMockRes = new CacheMockRes();
            HttpUtils.mockConnMaker.resourceStore.put(test, cacheMockRes);
        }
        if (orderIndex < 0) {
            cacheMockRes.resources.add(classpathRes);
        } else {
            while (orderIndex > cacheMockRes.resources.size() - 1) {
                cacheMockRes.resources.add(null);
            }
            cacheMockRes.resources.set(orderIndex, classpathRes);
        }
        return cacheMockRes;
    }

    public static CacheMockRes addMockApply(int orderIndex, String testStr, IClasspathRes classpathRes) {
        return HttpUtils.addMockApply(orderIndex, new MockMatchKey(testStr, false, false), classpathRes);
    }

    public static <T> T processContent(String urlString, ConfigFileContext.StreamProcess<T> process) {
        try {
            URL url = new URL(urlString);
            return ConfigFileContext.processContent(url, process);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T get(URL url, ConfigFileContext.StreamProcess<T> process) {
        return ConfigFileContext.processContent(url, process);
    }

    public static <T> T processContent(URL url, ConfigFileContext.StreamProcess<T> process) {
        return ConfigFileContext.processContent(url, process);
    }

    public static <T> T processContent(URL url, ConfigFileContext.StreamProcess<T> process, int maxRetry) {
        return ConfigFileContext.processContent(url, process, maxRetry);
    }

    public static <T> T post(URL url, byte[] content, PostFormStreamProcess<T> process) {
        return ConfigFileContext.processContent(url, content, process);
    }

    public static <T> T post(URL url, String content, PostFormStreamProcess<T> process) {
        return ConfigFileContext.processContent(url, content, process);
    }

    public static <T> T post(URL url, List<PostParam> params, PostFormStreamProcess<T> process) {
        return HttpUtils.process(url, params, process, ConfigFileContext.HTTPMethod.POST);
    }

    public static <T> T process(URL url, List<PostParam> params, PostFormStreamProcess<T> process, ConfigFileContext.HTTPMethod httpMethod) {
        return ConfigFileContext.processContent(url, process, httpMethod, process.getContentType().serializeParams(params), process.getMaxRetry());
    }

    public static <T> T post(String urlString, List<PostParam> params, PostFormStreamProcess<T> process) {
        try {
            URL url = new URL(urlString);
            return HttpUtils.post(url, params, process);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T delete(String urlString, List<PostParam> params, PostFormStreamProcess<T> process) {
        try {
            return HttpUtils.process(new URL(urlString), params, process, ConfigFileContext.HTTPMethod.DELETE);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T put(String urlString, List<PostParam> params, PostFormStreamProcess<T> process) {
        try {
            return HttpUtils.process(new URL(urlString), params, process, ConfigFileContext.HTTPMethod.PUT);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> AjaxResult<T> soapRemote(String url, Class<T> clazz) {
        return HttpUtils.soapRemote(url, Collections.emptyList(), clazz, true);
    }

    public static <T> AjaxResult<T> soapRemote(String url, List<PostParam> params, Class<T> clazz) {
        return HttpUtils.soapRemote(url, params, clazz, true);
    }

    public static <T> AjaxResult<T> soapRemote(String url, List<PostParam> params, final Class<T> clazz, final boolean errorShortCircuit) {
        return (AjaxResult)HttpUtils.post(url, params, new PostFormStreamProcess<AjaxResult<T>>(){

            @Override
            public PostFormStreamProcess.ContentType getContentType() {
                return PostFormStreamProcess.ContentType.Application_x_www_form_urlencoded;
            }

            @Override
            public boolean skipProxy() {
                return true;
            }

            @Override
            public void error(int status, InputStream errstream, IOException e) throws Exception {
                if (errorShortCircuit) {
                    super.error(status, errstream, e);
                } else {
                    logger.warn(e.getMessage());
                }
            }

            @Override
            public AjaxResult<T> p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                AjaxResult<Object> r = new AjaxResult<Object>();
                JSONObject result = null;
                try {
                    result = JSON.parseObject((String)IOUtils.toString((InputStream)stream, (Charset)TisUTF8.get()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                JSONArray errors = null;
                JSONArray msgs = null;
                r.setSuccess(result.getBoolean("success"));
                if (!r.isSuccess()) {
                    errors = result.getJSONArray("errormsg");
                    List<String> errMsg = errors.stream().map(rr -> {
                        if (rr instanceof String) {
                            return (String)rr;
                        }
                        if (rr instanceof JSONObject) {
                            JSONObject err = (JSONObject)rr;
                            return err.entrySet().stream().map(entry -> (String)entry.getKey() + "->" + entry.getValue()).collect(Collectors.joining("\n"));
                        }
                        throw new IllegalStateException("illegal type:" + rr.getClass().getName());
                    }).collect(Collectors.toList());
                    r.setErrormsg(errMsg);
                    if (errorShortCircuit) {
                        throw new IllegalStateException(Joiner.on((String)"\n").join(r.getErrormsg()));
                    }
                }
                msgs = result.getJSONArray("msg");
                r.setMsg(msgs.stream().map(m -> (String)m).collect(Collectors.toList()));
                if (clazz == Void.class) {
                    return r;
                }
                if (result.containsKey((Object)"bizresult")) {
                    r.setBizresult(result.getObject("bizresult", clazz));
                }
                return r;
            }
        });
    }

    public static abstract class LatestUpdateTimestampClasspathRes
    implements IClasspathRes {
        @Override
        public Map<String, List<String>> headerFields() {
            return ImmutableMap.of((Object)"lastupdate", (Object)Lists.newArrayList((Object[])new String[]{String.valueOf(System.currentTimeMillis())}));
        }
    }

    public static class ClasspathRes
    implements IClasspathRes {
        public final int order;
        private final String classpath;
        private final Class<?> relClass;

        public ClasspathRes(int order, String classpath, Class<?> relClass) {
            this.classpath = classpath;
            this.relClass = relClass;
            this.order = order;
        }

        @Override
        public InputStream getResourceAsStream(URL url) {
            return this.getResourceAsStream(this.classpath);
        }

        public InputStream getResourceAsStream(String cpResName) {
            return this.relClass.getResourceAsStream(cpResName);
        }
    }

    public static interface IClasspathRes {
        public InputStream getResourceAsStream(URL var1);

        default public Map<String, List<String>> headerFields() {
            return Collections.emptyMap();
        }
    }

    public static class CacheMockRes {
        int getIndex = 0;
        List<IClasspathRes> resources = Lists.newArrayList();
        IClasspathRes lastElemnet = null;
        int resFetchCount = 0;

        public boolean verfiyResHasFetch() {
            return this.resFetchCount > 0;
        }

        IClasspathRes get() {
            IClasspathRes res = null;
            res = this.getIndex >= this.resources.size() ? this.lastElemnet : (this.lastElemnet = this.resources.get(this.getIndex++));
            final IClasspathRes finalRes = res;
            return new IClasspathRes(){

                @Override
                public InputStream getResourceAsStream(URL url) {
                    ++resFetchCount;
                    return finalRes.getResourceAsStream(url);
                }

                @Override
                public Map<String, List<String>> headerFields() {
                    return finalRes.headerFields();
                }
            };
        }
    }

    public static class DefaultMockConnectionMaker
    implements MockConnectionMaker {
        private final Map<MockMatchKey, CacheMockRes> resourceStore = Maps.newHashMap();

        public void clearStubs() {
            this.resourceStore.clear();
        }

        @Override
        public MockHttpURLConnection create(URL url, List<ConfigFileContext.Header> heads, ConfigFileContext.HTTPMethod method, byte[] content) {
            MockMatchKey matchKey = null;
            for (Map.Entry<MockMatchKey, CacheMockRes> entry : this.resourceStore.entrySet()) {
                matchKey = entry.getKey();
                if (!(matchKey.startWith ? StringUtils.startsWith((String)url.toString(), (String)matchKey.matchTxt) : (matchKey.endWith ? StringUtils.endsWith((String)url.toString(), (String)matchKey.matchTxt) : StringUtils.indexOf((String)url.toString(), (String)matchKey.matchTxt) > -1))) continue;
                return this.createConnection(url, heads, method, content, entry.getValue().get());
            }
            return null;
        }

        protected MockHttpURLConnection createConnection(URL url, List<ConfigFileContext.Header> heads, ConfigFileContext.HTTPMethod method, byte[] content, IClasspathRes cpRes) {
            return new MockHttpURLConnection(cpRes.getResourceAsStream(url), cpRes.headerFields());
        }
    }

    public static class MockMatchKey {
        private final String matchTxt;
        private final boolean startWith;
        private final boolean endWith;

        public MockMatchKey(String matchTxt, boolean startWith, boolean endWith) {
            this.matchTxt = matchTxt;
            this.startWith = startWith;
            this.endWith = endWith;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockMatchKey that = (MockMatchKey)o;
            return Objects.equals(this.matchTxt, that.matchTxt);
        }

        public int hashCode() {
            return Objects.hash(this.matchTxt);
        }
    }

    public static class PostParam {
        private final String key;
        private final Object value;

        public PostParam(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        @JSONField(serialize=false)
        public String getValue() {
            return String.valueOf(this.value);
        }

        public Object getRawVal() {
            return this.value;
        }
    }

    public static interface IMsgProcess {
        public void err(String var1);
    }
}

