/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class GCJmxUtils {
    private static final MBeanServer DEFAULT_MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private static ObjectName youngGCObjectName = null;
    private static ObjectName fullGCObjectName = null;

    public static long getYongGC() throws Exception {
        return GCJmxUtils.getYoungGC(DEFAULT_MBEAN_SERVER);
    }

    public static long getFullGC() throws Exception {
        return GCJmxUtils.getFullGC(DEFAULT_MBEAN_SERVER);
    }

    private static long getYoungGC(MBeanServerConnection mbeanServer) throws Exception {
        if (youngGCObjectName == null) {
            youngGCObjectName = mbeanServer.isRegistered(new ObjectName("java.lang:type=GarbageCollector,name=ParNew")) ? new ObjectName("java.lang:type=GarbageCollector,name=ParNew") : (mbeanServer.isRegistered(new ObjectName("java.lang:type=GarbageCollector,name=Copy")) ? new ObjectName("java.lang:type=GarbageCollector,name=Copy") : new ObjectName("java.lang:type=GarbageCollector,name=PS Scavenge"));
        }
        return (Long)mbeanServer.getAttribute(youngGCObjectName, "CollectionCount");
    }

    private static long getFullGC(MBeanServerConnection mbeanServer) throws Exception {
        if (fullGCObjectName == null) {
            fullGCObjectName = mbeanServer.isRegistered(new ObjectName("java.lang:type=GarbageCollector,name=ConcurrentMarkSweep")) ? new ObjectName("java.lang:type=GarbageCollector,name=ConcurrentMarkSweep") : (mbeanServer.isRegistered(new ObjectName("java.lang:type=GarbageCollector,name=MarkSweepCompact")) ? new ObjectName("java.lang:type=GarbageCollector,name=MarkSweepCompact") : new ObjectName("java.lang:type=GarbageCollector,name=PS MarkSweep"));
        }
        return (Long)mbeanServer.getAttribute(fullGCObjectName, "CollectionCount");
    }

    public static void main(String[] args) throws Exception {
        long curr = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            GCJmxUtils.getFullGC();
            System.out.println(GCJmxUtils.getYongGC());
            Thread.sleep(1000L);
        }
        System.out.println(System.currentTimeMillis() - curr);
    }
}

