/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.google.common.collect.Lists;
import com.qlangtech.tis.lang.ErrorValue;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.IURLConnectionSender;
import com.qlangtech.tis.manage.common.MockHttpURLConnection;
import com.qlangtech.tis.manage.common.PostFormStreamProcess;
import com.qlangtech.tis.manage.common.PropteryGetter;
import com.qlangtech.tis.manage.common.TisUTF8;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileContext {
    public static final String KEY_HEAD_FILE_MD5 = "filemd5";
    public static final String KEY_HEAD_LAST_UPDATE = "lastupdate";
    public static final String KEY_HEAD_FILE_NOT_EXIST = "notexist";
    public static final String KEY_HEAD_FILE_SIZE = "content-size";
    public static final String KEY_HEAD_FILE_DOWNLOAD = "download";
    public static final String KEY_HEAD_FILES = "dirlist";
    private static final int DEFAULT_MAX_CONNECT_RETRY_COUNT = 1;
    private static final Logger logger = LoggerFactory.getLogger(ConfigFileContext.class);

    public static void main(String[] arg) throws Exception {
    }

    public static byte[] getBytesContent(Integer bizid, Integer appid, Short groupIndex, Short runtimeEnvironment, PropteryGetter getter, String terminatorRepository, final String md5ValidateCode) throws MalformedURLException, IOException {
        URL url = new URL(terminatorRepository + "/download/publish/" + bizid + "/" + appid + "/group" + groupIndex + "/r" + runtimeEnvironment + "/" + getter.getFileName());
        return ConfigFileContext.processContent(url, new PostFormStreamProcess<byte[]>(){

            @Override
            public PostFormStreamProcess.ContentType getContentType() {
                return null;
            }

            @Override
            public byte[] p(int status, InputStream stream, Map<String, List<String>> getHeaderFields) {
                String remoteMd5 = md5ValidateCode;
                List<String> md5 = getHeaderFields.get(ConfigFileContext.KEY_HEAD_FILE_MD5);
                Optional filemd5 = md5.stream().findFirst();
                if (!filemd5.isPresent()) {
                    throw new IllegalStateException("head key:filemd5 is not exist in response header");
                }
                if (!StringUtils.equalsIgnoreCase((String)remoteMd5, (String)((String)filemd5.get()))) {
                    throw new IllegalStateException("filemd5:" + filemd5 + " remoteMd5:" + remoteMd5);
                }
                try {
                    return IOUtils.toByteArray((InputStream)stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static <T> T processContent(URL url, StreamProcess<T> process) {
        return ConfigFileContext.processContent(url, process, 1);
    }

    public static <T> T processContent(URL url, StreamProcess<T> process, int retryCount) {
        return ConfigFileContext.processContent(url, process, HTTPMethod.GET, null, retryCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T processContent(URL url, StreamProcess<T> process, HTTPMethod method, byte[] content, int maxRetry) {
        reader = null;
        retryCount = 0;
        while (true) {
            try {
                conn = ConfigFileContext.getNetInputStream(url, process, method, content);
                try {
                    reader = conn.getInputStream();
                    ** GOTO lbl21
                }
                catch (IOException e) {
                    errStream = null;
                    errStream = conn.getErrorStream();
                    process.error(conn.getResponseCode(), errStream, e);
                    var10_15 = null;
                    reader.close();
                    return var10_15;
                    catch (Throwable var11_16) {
                        // empty catch block
                    }
                    return var10_15;
lbl21:
                    // 1 sources

                    e = process.p(conn, reader);
                    return e;
                    finally {
                        IOUtils.closeQuietly((InputStream)errStream);
                    }
                }
            }
            catch (Exception e) {
                if (++retryCount >= maxRetry) {
                    throw TisException.create(ErrorValue.create(TisException.ErrorCode.HTTP_CONNECT_FAILD, Collections.emptyMap()), "maxRetry:" + maxRetry + ",url:" + url.toString() + "," + e.getMessage(), e);
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                ConfigFileContext.logger.warn(e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable var7_9) {}
                continue;
            }
            break;
        }
    }

    private static HttpURLConnection getNetInputStream(URL url, StreamProcess streamProcess, HTTPMethod method, byte[] content) throws IOException {
        MockHttpURLConnection conn;
        List<Header> heads = streamProcess.getHeaders();
        if (HttpUtils.mockConnMaker != null && (conn = HttpUtils.mockConnMaker.create(url, heads, method, content)) != null) {
            return conn;
        }
        try {
            HttpClient.Builder clientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(15L)).followRedirects(HttpClient.Redirect.NEVER);
            HttpClient client = IURLConnectionSender.setBuilder(clientBuilder, streamProcess.skipProxy()).build();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(url.toURI()).timeout(streamProcess.getSocketReadTimeout()).header("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 (.NET CLR 3.5.30729)");
            for (Header h : heads) {
                requestBuilder.header(h.getKey(), h.getValue());
            }
            HttpRequest.BodyPublisher bodyPublisher = content != null ? HttpRequest.BodyPublishers.ofByteArray(content) : HttpRequest.BodyPublishers.noBody();
            switch (method) {
                case GET: {
                    requestBuilder.GET();
                    break;
                }
                case POST: {
                    requestBuilder.POST(bodyPublisher);
                    break;
                }
                case PUT: {
                    requestBuilder.PUT(bodyPublisher);
                    break;
                }
                case DELETE: {
                    requestBuilder.DELETE();
                    break;
                }
                case HEAD: {
                    requestBuilder.method("HEAD", HttpRequest.BodyPublishers.noBody());
                    break;
                }
                case OPTIONS: {
                    requestBuilder.method("OPTIONS", HttpRequest.BodyPublishers.noBody());
                    break;
                }
                case TRACE: {
                    requestBuilder.method("TRACE", HttpRequest.BodyPublishers.noBody());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported HTTP method: " + method);
                }
            }
            HttpRequest request = requestBuilder.build();
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() == 404) {
                throw new IllegalStateException("ERROR_CODE=" + response.statusCode() + "  request faild, revsion center apply url :" + url);
            }
            return new HttpClientResponseAdapter(response, url);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URL: " + url, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Request interrupted", e);
        }
    }

    public static Header setAuthorizationHeader(String userName, String password) {
        if (StringUtils.isEmpty((String)userName)) {
            throw new IllegalArgumentException("username can not be empty");
        }
        String userpass = userName + ":" + StringUtils.trimToEmpty((String)password);
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes()));
        return new Header("Authorization", basicAuth);
    }

    public static <T> T processContent(URL url, String content, PostFormStreamProcess<T> process) {
        return ConfigFileContext.processContent(url, content.getBytes(Charset.defaultCharset()), process);
    }

    public static <T> T processContent(URL url, byte[] content, PostFormStreamProcess<T> process) {
        return ConfigFileContext.processContent(url, process, HTTPMethod.POST, content, 1);
    }

    static <T> T processDeleteContent(URL url, String content, PostFormStreamProcess<T> process) {
        return ConfigFileContext.processDeleteContent(url, content.getBytes(Charset.defaultCharset()), process);
    }

    static <T> T processDeleteContent(URL url, byte[] content, PostFormStreamProcess<T> process) {
        return ConfigFileContext.processContent(url, process, HTTPMethod.DELETE, content, 1);
    }

    private static class HttpClientResponseAdapter
    extends HttpURLConnection {
        private final HttpResponse<InputStream> response;
        private final int responseCode;
        private final Map<String, List<String>> headerFields;

        public HttpClientResponseAdapter(HttpResponse<InputStream> response, URL url) {
            super(url);
            this.response = response;
            this.responseCode = response.statusCode();
            this.headerFields = response.headers().map();
        }

        @Override
        public void disconnect() {
            try {
                this.response.body().close();
            }
            catch (IOException e) {
                logger.warn("Failed to close response body", (Throwable)e);
            }
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.responseCode;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.response.body();
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return this.headerFields;
        }

        @Override
        public String getHeaderField(String name) {
            List<String> values = this.headerFields.get(name);
            return values != null && !values.isEmpty() ? values.get(0) : null;
        }
    }

    public static class Header {
        private final String key;
        private final String value;

        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum HTTPMethod {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        DELETE,
        TRACE;

    }

    public static abstract class StreamProcess<T>
    extends StreamErrorProcess {
        public static String HEADER_KEY_GET_FILE_META = "get_file_meta";
        protected static final List<Header> HEADER_TEXT_HTML = Lists.newArrayList((Object[])new Header[]{new Header("content-type", "text/html")});
        protected static final List<Header> HEADER_GET_META;
        public static final Duration dftSocketReadTimeout;

        public T p(HttpURLConnection conn, InputStream stream) throws IOException {
            return this.p(conn.getResponseCode(), stream, conn.getHeaderFields());
        }

        public abstract T p(int var1, InputStream var2, Map<String, List<String>> var3) throws IOException;

        public List<Header> getHeaders() {
            return HEADER_TEXT_HTML;
        }

        public boolean skipProxy() {
            return false;
        }

        public Duration getSocketReadTimeout() {
            return dftSocketReadTimeout;
        }

        static {
            ArrayList tmpList = Lists.newArrayList(HEADER_TEXT_HTML);
            tmpList.add(new Header(HEADER_KEY_GET_FILE_META, String.valueOf(true)));
            HEADER_GET_META = Collections.unmodifiableList(tmpList);
            dftSocketReadTimeout = Duration.ofSeconds(40L);
        }
    }

    public static class StreamErrorProcess {
        public void error(int status, InputStream errstream, IOException e) throws Exception {
            logger.error("error code:" + status + "\n" + (errstream != null ? IOUtils.toString((InputStream)errstream, (Charset)TisUTF8.get()) : "errstream is null"));
            throw new Exception(e);
        }
    }

    public static abstract class ContentProcess {
        public abstract void execute(PropteryGetter var1, byte[] var2) throws Exception;
    }
}

