/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.google.common.collect.Lists;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterResource {
    private static final Logger logger = LoggerFactory.getLogger(CenterResource.class);
    public static final String KEY_LAST_MODIFIED_EXTENDION = ".lastmodified";
    public static final String KEY_notFetchFromCenterRepository = "notFetchFromCenterRepository";
    private static Boolean notFetchFromCenterRepository;

    public static boolean notFetchFromCenterRepository() {
        if (notFetchFromCenterRepository == null) {
            notFetchFromCenterRepository = Boolean.getBoolean(KEY_notFetchFromCenterRepository);
            logger.info("notFetchFromCenterRepository:{}", (Object)notFetchFromCenterRepository);
        }
        return notFetchFromCenterRepository;
    }

    public static void setNotFetchFromCenterRepository() {
        CenterResource.setFetchFromCenterRepository(true);
    }

    public static void setFetchFromCenterRepository(boolean notFetchFromCenterRepository) {
        System.setProperty(KEY_notFetchFromCenterRepository, String.valueOf(notFetchFromCenterRepository));
        CenterResource.notFetchFromCenterRepository = null;
    }

    private static void copyFromRemote2Local(URL url, File local) {
        CenterResource.copyFromRemote2Local(url, local, false);
    }

    public static Pair<Boolean, File> copyFromRemote2Local(String filePath, boolean isConfig) {
        URL url = CenterResource.getPathURL((isConfig ? "cfg_repo" : "libs") + "/" + filePath);
        File local = new File(isConfig ? Config.getMetaCfgDir() : Config.getLibDir(), filePath);
        return Pair.of((Object)CenterResource.copyFromRemote2Local(url, local, false), (Object)local);
    }

    public static List<String> getSubDirs(String relativePath) {
        return CenterResource.getSubFiles(relativePath, true, false);
    }

    public static List<File> synchronizeSubFiles(String relativePath) {
        List<String> subFiles = CenterResource.getSubFiles(relativePath, false, true);
        ArrayList subs = Lists.newArrayList();
        for (String f : subFiles) {
            subs.add((File)CenterResource.copyFromRemote2Local(CenterResource.getPath(relativePath, f), true).getValue());
        }
        return subs;
    }

    public static List<String> getSubFiles(String relativePath, final boolean dir, final boolean file) {
        if (CenterResource.notFetchFromCenterRepository()) {
            File parent = new File(Config.getMetaCfgDir(), relativePath);
            if (!parent.exists()) {
                throw new IllegalStateException("parent:" + parent.getAbsolutePath() + " is not exist");
            }
            File c = null;
            ArrayList suNames = Lists.newArrayList();
            for (String child : parent.list()) {
                c = new File(parent, child);
                if ((!c.isFile() || !file) && (!c.isDirectory() || !dir)) continue;
                suNames.add(child);
            }
            return suNames;
        }
        URL url = CenterResource.getPathURL("cfg_repo", relativePath);
        ArrayList subDirs = Lists.newArrayList();
        subDirs.addAll((Collection)HttpUtils.get(url, new ConfigFileContext.StreamProcess<List<String>>(){

            @Override
            public List<ConfigFileContext.Header> getHeaders() {
                return HEADER_GET_META;
            }

            @Override
            public List<String> p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                String[] childs;
                if (CenterResource.isTargetResourceNotExist(headerFields)) {
                    return Collections.emptyList();
                }
                List<String> subChild = headerFields.get("dirlist");
                Optional first = subChild.stream().findFirst();
                if (!first.isPresent()) {
                    return Collections.emptyList();
                }
                ArrayList result = Lists.newArrayList();
                for (String c : childs = StringUtils.split((String)((String)first.get()), (String)",")) {
                    if (dir && StringUtils.endsWith((String)c, (String)":d")) {
                        result.add(StringUtils.substringBefore((String)c, (String)":"));
                    }
                    if (!file || !StringUtils.endsWith((String)c, (String)":f")) continue;
                    result.add(StringUtils.substringBefore((String)c, (String)":"));
                }
                return result;
            }
        }));
        return subDirs;
    }

    public static Boolean copyFromRemote2Local(final URL url, final File local, boolean directDownload) {
        if (CenterResource.notFetchFromCenterRepository()) {
            return false;
        }
        return HttpUtils.get(url, new ConfigFileContext.StreamProcess<Boolean>(){

            @Override
            public Boolean p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                FileUtils.deleteQuietly((File)local);
                if (CenterResource.isTargetResourceNotExist(headerFields)) {
                    logger.warn("remote resource not exist:" + url);
                    return false;
                }
                try {
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)local);
                }
                catch (IOException e) {
                    throw new RuntimeException("local file:" + local.getAbsolutePath(), e);
                }
                return true;
            }
        });
    }

    private static boolean isTargetResourceNotExist(Map<String, List<String>> headerFields) {
        List<String> notExist = headerFields.get("notexist");
        return notExist != null && notExist.contains(Boolean.TRUE.toString());
    }

    public static String getPath(String parent, String filePath) {
        boolean parentEndWithSlash = StringUtils.endsWith((String)parent, (String)"/");
        boolean childStartWithSlash = StringUtils.startsWith((String)filePath, (String)"/");
        filePath = parentEndWithSlash && childStartWithSlash ? parent + StringUtils.substring((String)filePath, (int)1) : (!parentEndWithSlash && !childStartWithSlash ? parent + "/" + (String)filePath : parent + (String)filePath);
        return filePath;
    }

    public static URL getPathURL(String parent, String filePath) {
        return CenterResource.getPathURL(CenterResource.getPath(parent, filePath));
    }

    public static URL getPathURL(String filePath) {
        try {
            RunEnvironment runtime = RunEnvironment.getSysRuntime();
            return new URL(runtime.getInnerRepositoryURL() + "/config/stream_script_repo.action?path=" + URLEncoder.encode(filePath, TisUTF8.getName()));
        }
        catch (Exception e) {
            throw new RuntimeException("filepath:" + filePath, e);
        }
    }
}

