/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.lang;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.lang.ErrorValue;
import com.qlangtech.tis.lang.ILogErrorDetail;
import com.qlangtech.tis.lang.PayloadLink;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.runtime.module.misc.BasicRundata;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.utils.FreshmanReadmeToken;
import com.qlangtech.tis.web.start.TisAppLaunch;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class TisException
extends RuntimeException {
    private final Optional<ErrorValue> errCode;
    private PayloadLink payloadLink;
    private static final String KEY_DETAIL = "detail";
    private static final String KEY_ABSTRACT = "abstract";
    private static final Pattern p = Pattern.compile("\\d{" + "yyyyMMddHHmmssSSS".length() + "}");

    public static ErrorCode parse(String val) {
        ErrorCode errCode = ErrorCode.valueOf(val);
        return errCode;
    }

    public static ErrMsg getErrMsg(Throwable throwable) {
        TisException except = TisException.find(throwable);
        if (except == null) {
            Throwable cause = throwable.getCause();
            return new ErrMsg(org.apache.commons.lang3.exception.ExceptionUtils.getRootCauseMessage((Throwable)throwable), cause != null ? cause : throwable, Optional.empty());
        }
        return new ErrMsg(except.getMessage(), except, except.errCode);
    }

    private static TisException find(Throwable throwable) {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)throwable);
        TisException last = null;
        for (Throwable ex : throwables) {
            if (!TisException.class.isAssignableFrom(ex.getClass())) continue;
            if (last == null) {
                last = (TisException)ex;
                continue;
            }
            if (!((TisException)ex).errCode.isPresent()) continue;
            last = (TisException)ex;
        }
        return last;
    }

    private TisException(Optional<ErrorValue> errorCode, String message) {
        super(message);
        this.errCode = errorCode;
    }

    private TisException(Optional<ErrorValue> errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errCode = errorCode;
    }

    private TisException(String message) {
        super(message);
        this.errCode = Optional.empty();
    }

    public TisException setPayloadLink(PayloadLink payloadLink) {
        this.payloadLink = payloadLink;
        return this;
    }

    public Optional<PayloadLink> getPayloadLink() {
        return Optional.ofNullable(this.payloadLink);
    }

    public static TisException create(String message, Throwable cause) {
        return TisException.create(null, message, cause);
    }

    public static TisException create(ErrorValue errorCode, String message) {
        return new TisException(Optional.ofNullable(errorCode), message);
    }

    public static TisException create(ErrorValue errorCode, String message, Throwable cause) {
        if (cause instanceof TisException) {
            return (TisException)cause;
        }
        return new TisException(Optional.ofNullable(errorCode), message, cause);
    }

    public static TisException create(String message) {
        return new TisException(message);
    }

    public static List<ErrMsg> getErrorLogs() {
        File errLogDir = TisException.getErrLogDir();
        String[] logs = errLogDir.list();
        if (logs == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList(Arrays.stream(logs).filter(l -> p.matcher((CharSequence)l).matches()).map(l -> {
            ErrMsg errMsg = new ErrMsg(null, null, Optional.empty());
            errMsg.logFileName = Long.parseLong(l);
            return errMsg;
        }).iterator());
        Collections.sort(result, (a, b) -> a.logFileName >= b.logFileName ? -1 : 1);
        return result;
    }

    private static File getErrLogFile(String logFileName) {
        return new File(TisException.getErrLogDir(), logFileName);
    }

    private static File getErrLogDir() {
        return new File(TisAppLaunch.getLogDir(), "syserrs");
    }

    public static ILogErrorDetail getLogError(String logFileName) {
        if (StringUtils.isEmpty((String)logFileName)) {
            throw new IllegalArgumentException("param logFileName can not be null");
        }
        final File errLogFile = TisException.getErrLogFile(logFileName);
        final AtomicReference error = new AtomicReference();
        return new ILogErrorDetail(){

            @Override
            public String getDetail() {
                return this.getPersisObj().getString(TisException.KEY_DETAIL);
            }

            private JSONObject getPersisObj() {
                return (JSONObject)error.updateAndGet(pre -> {
                    try {
                        if (pre == null) {
                            pre = JSON.parseObject((String)FileUtils.readFileToString((File)errLogFile, (Charset)TisUTF8.get()));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return pre;
                });
            }

            @Override
            public String getAbstractInfo() {
                return this.getPersisObj().getString(TisException.KEY_ABSTRACT);
            }
        };
    }

    public static class ErrMsg {
        static final ThreadLocal<SimpleDateFormat> formatOfyyyyMMddHHmmssMMM = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyyMMddHHmmssSSS");
            }
        };
        static final AtomicReference<ErrMsg> preErr = new AtomicReference();
        private final String message;
        @JSONField(serialize=false)
        private final Throwable ex;
        private long logFileName;
        private String abstractInfo;
        private final Optional<ErrorValue> errCode;

        public ErrMsg(String message, Throwable ex, Optional<ErrorValue> errCode) {
            this.message = message;
            this.ex = ex;
            this.errCode = Objects.requireNonNull(errCode, "errCode can not be null");
        }

        @JSONField(serialize=false)
        public Throwable getEx() {
            return this.ex;
        }

        public ErrorValue getErrCode() {
            return this.errCode.orElse(null);
        }

        public String getLogFileName() {
            return String.valueOf(this.logFileName);
        }

        public String getAbstractInfo() {
            return this.abstractInfo;
        }

        public void setAbstractInfo(String abstractInfo) {
            this.abstractInfo = abstractInfo;
        }

        public long getCreateTime() {
            try {
                return formatOfyyyyMMddHHmmssMMM.get().parse(String.valueOf(this.logFileName)).getTime();
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.logFileName + "/" + this.message;
        }

        public ErrMsg writeLogErr() {
            Objects.requireNonNull(this.ex, "exception can not be null");
            this.logFileName = Long.parseLong(IParamContext.getCurrentMillisecTimeStamp());
            ErrMsg currError = this;
            return preErr.updateAndGet(pre -> {
                try {
                    if (pre != null && StringUtils.equals((String)pre.getMessage(), (String)currError.getMessage())) {
                        return pre;
                    }
                    File errLog = TisException.getErrLogFile(String.valueOf(this.logFileName));
                    StringWriter errWriter = new StringWriter();
                    try (PrintWriter print = new PrintWriter(errWriter);){
                        this.ex.printStackTrace(print);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(errLog.getAbsolutePath(), e);
                    }
                    String detail = errWriter.toString();
                    JSONObject err = new JSONObject();
                    err.put(TisException.KEY_ABSTRACT, (Object)this.ex.getMessage());
                    err.put(TisException.KEY_DETAIL, (Object)detail);
                    FileUtils.write((File)errLog, (CharSequence)JsonUtil.toString(err), (Charset)TisUTF8.get());
                    return currError;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static enum ErrorCode {
        HTTP_CONNECT_FAILD(rundata -> {
            throw new UnsupportedOperationException();
        }),
        LICENSE_INVALID(rundata -> null),
        FLINK_INSTANCE_LOSS_OF_CONTACT(rundata -> {
            String appName = rundata.getStringParam("appname");
            if (StringUtils.isEmpty((String)appName)) {
                throw new IllegalArgumentException("request param appname can not be null");
            }
            return new String[]{"coredefine", "core_action", "incr_delete"};
        }),
        FLINK_SESSION_CLUSTER_LOSS_OF_CONTACT(new RemoveDataxWorkerForward()),
        TIS_FRESHMAN_README_HAVE_NOT_READ(rundata -> {
            boolean remindMeLater = Boolean.parseBoolean(rundata.getStringParam("remindMeLater"));
            FreshmanReadmeToken.setFreshManReadmeHasRead(remindMeLater);
            return null;
        }),
        POWER_JOB_CLUSTER_LOSS_OF_CONTACT(new RemoveDataxWorkerForward(){

            @Override
            public String[] apply(BasicRundata rundata) {
                String[] forwardParams = super.apply(rundata);
                if (!TargetResName.K8S_DATAX_INSTANCE_NAME.equalWithName(rundata.getStringParam("targetName"))) {
                    throw new IllegalArgumentException("request param:targetName relevant val must be equal to:" + TargetResName.K8S_DATAX_INSTANCE_NAME.getName());
                }
                return forwardParams;
            }
        });

        private final Function<BasicRundata, String[]> forward;

        private ErrorCode(Function<BasicRundata, String[]> forward) {
            this.forward = forward;
        }

        public void execForward(BasicRundata rundata) {
            String[] forwardParams = this.forward.apply(rundata);
            if (forwardParams != null) {
                BasicRundata.forward(rundata, forwardParams);
            }
        }
    }

    private static class RemoveDataxWorkerForward
    implements Function<BasicRundata, String[]> {
        private RemoveDataxWorkerForward() {
        }

        @Override
        public String[] apply(BasicRundata rundata) {
            String targetName = rundata.getStringParam("targetName");
            if (StringUtils.isEmpty((String)targetName)) {
                throw new IllegalArgumentException("request param targetName can not be null");
            }
            return new String[]{"coredefine", "datax_action", "remove_datax_worker"};
        }
    }
}

