/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.hive;

import com.qlangtech.tis.plugin.ds.DataType;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class HiveColumn {
    public static String HIVE_TYPE_TIMESTAMP = "TIMESTAMP";
    private String name;
    private boolean nullable;
    private String rawName;
    public DataType dataType;
    private int index;
    private String defalutValue;
    public static DataType.TypeVisitor<String> hiveTypeVisitor = new DataType.TypeVisitor<String>(){

        public String bigInt(DataType type) {
            return "BIGINT";
        }

        public String timeType(DataType type) {
            return this.timestampType(type);
        }

        public String decimalType(DataType type) {
            return "DECIMAL(" + type.getColumnSize() + "," + type.getDecimalDigits() + ")";
        }

        public String intType(DataType type) {
            return "INT";
        }

        public String tinyIntType(DataType dataType) {
            return "TINYINT";
        }

        public String smallIntType(DataType dataType) {
            return "SMALLINT";
        }

        public String boolType(DataType dataType) {
            return "BOOLEAN";
        }

        public String floatType(DataType type) {
            return "FLOAT";
        }

        public String doubleType(DataType type) {
            return "DOUBLE";
        }

        public String dateType(DataType type) {
            return "DATE";
        }

        public String timestampType(DataType type) {
            return HIVE_TYPE_TIMESTAMP;
        }

        public String bitType(DataType type) {
            return "BINARY";
        }

        public String blobType(DataType type) {
            return "BINARY";
        }

        public String varcharType(DataType type) {
            if (type.getColumnSize() > 500 || type.getColumnSize() < 1) {
                return "STRING";
            }
            return "VARCHAR(" + type.getColumnSize() + ")";
        }
    };

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.getRawName() == null) {
            this.setRawName(name);
        }
    }

    public String getDataType() {
        return (String)Objects.requireNonNull(this.dataType, "dataType can not be null").accept(hiveTypeVisitor);
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String getRawName() {
        return this.rawName;
    }

    public void setRawName(String rawName) {
        this.rawName = rawName;
        if (this.getName() == null) {
            this.setName(rawName);
        }
    }

    public String getDefalutValue() {
        return this.defalutValue;
    }

    public void setDefalutValue(String defalutValue) {
        this.defalutValue = defalutValue;
    }

    public boolean hasAliasName() {
        return !StringUtils.equals((String)this.rawName, (String)this.name);
    }

    public boolean hasDefaultValue() {
        return !StringUtils.isBlank((String)this.defalutValue);
    }

    public String toString() {
        return this.getRawName() + " " + this.getName();
    }
}

