/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.phasestatus.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.fullbuild.phasestatus.IChildProcessStatusVisitor;
import com.qlangtech.tis.fullbuild.phasestatus.IJoinTaskStatus;
import com.qlangtech.tis.fullbuild.phasestatus.IProcessDetailStatus;
import com.qlangtech.tis.fullbuild.phasestatus.JobLog;
import com.qlangtech.tis.fullbuild.phasestatus.impl.AbstractChildProcessStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BasicPhaseStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JoinPhaseStatus
extends BasicPhaseStatus<JoinTaskStatus> {
    @JSONField(serialize=false)
    public final Map<String, JoinTaskStatus> taskStatus = Maps.newConcurrentMap();

    public JoinPhaseStatus(int taskid) {
        super(taskid);
    }

    @Override
    public boolean isShallOpen() {
        return JoinPhaseStatus.shallOpenView(this.taskStatus.values());
    }

    public void setAllComplete() {
        this.taskStatus.values().forEach(t -> {
            t.setComplete(true);
            t.setFaild(false);
            t.jobsLog().forEach(l -> {
                l.setMapper(100);
                l.setReducer(100);
                l.setWaiting(false);
            });
        });
    }

    @Override
    protected FullbuildPhase getPhase() {
        return FullbuildPhase.JOIN;
    }

    @Override
    protected Collection<JoinTaskStatus> getChildStatusNode() {
        return this.taskStatus.values();
    }

    public JoinTaskStatus getTaskStatus(String taskName) {
        JoinTaskStatus sqlExecState = this.taskStatus.get(taskName);
        if (sqlExecState == null) {
            sqlExecState = new JoinTaskStatus(taskName);
            this.taskStatus.put(taskName, sqlExecState);
        }
        return sqlExecState;
    }

    @Override
    public IProcessDetailStatus<JoinTaskStatus> getProcessStatus() {
        return new IProcessDetailStatus<JoinTaskStatus>(){

            @Override
            public Collection<JoinTaskStatus> getDetails() {
                if (JoinPhaseStatus.this.taskStatus.isEmpty()) {
                    JoinTaskStatus mock = new JoinTaskStatus("");
                    mock.setWaiting(true);
                    return Collections.singleton(mock);
                }
                return JoinPhaseStatus.this.taskStatus.values();
            }

            @Override
            public int getProcessPercent() {
                return 0;
            }

            @Override
            public void detailVisit(IChildProcessStatusVisitor visitor) {
                for (JoinTaskStatus status : JoinPhaseStatus.this.taskStatus.values()) {
                    visitor.visit(status);
                }
            }
        };
    }

    public static class JoinTaskStatus
    extends AbstractChildProcessStatus
    implements IJoinTaskStatus {
        private final String joinTaskName;
        @JSONField(serialize=false)
        public Map<Integer, JobLog> jobsStatus = new HashMap<Integer, JobLog>();

        public JoinTaskStatus(String taskname) {
            this.joinTaskName = taskname;
        }

        public void setStart() {
            this.setWaiting(false);
        }

        @Override
        public String getAll() {
            return String.valueOf(this.jobsStatus.size() * 100);
        }

        @JSONField(serialize=false)
        public Collection<JobLog> jobsLog() {
            return this.jobsStatus.values();
        }

        private long executed() {
            long result = 0L;
            for (JobLog log : this.jobsStatus.values()) {
                result += (long)log.getPercent();
            }
            return result;
        }

        @Override
        public String getProcessed() {
            return String.valueOf(this.executed());
        }

        @Override
        public int getPercent() {
            int size = this.jobsStatus.size();
            if (size > 0) {
                return (int)(this.executed() / (long)size);
            }
            return 0;
        }

        @Override
        public String getName() {
            return this.joinTaskName;
        }

        public JobLog getJoblog(Integer jobid) {
            JobLog jobLog = this.jobsStatus.get(jobid);
            if (jobLog == null) {
                throw new IllegalStateException("jobid:" + jobid + " relevant joblog can not be null,jobsStatus keys:" + this.jobsStatus.keySet());
            }
            return jobLog;
        }

        public void createJobStatus(Integer jobid) {
            this.jobsStatus.put(jobid, new JobLog());
            this.setWaiting(false);
        }
    }
}

