/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.phasestatus.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.fullbuild.phasestatus.IChildProcessStatusVisitor;
import com.qlangtech.tis.fullbuild.phasestatus.IProcessDetailStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.AbstractChildProcessStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BasicPhaseStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class IndexBackFlowPhaseStatus
extends BasicPhaseStatus<NodeBackflowStatus> {
    public static final String KEY_INDEX_BACK_FLOW_STATUS = "index_back_flow_status";
    @JSONField(serialize=false)
    public final Map<String, NodeBackflowStatus> nodesStatus = Maps.newConcurrentMap();

    public IndexBackFlowPhaseStatus(int taskid) {
        super(taskid);
    }

    @Override
    protected FullbuildPhase getPhase() {
        return FullbuildPhase.IndexBackFlow;
    }

    @Override
    public boolean isShallOpen() {
        return IndexBackFlowPhaseStatus.shallOpenView(this.nodesStatus.values());
    }

    public NodeBackflowStatus getNode(String nodeName) {
        NodeBackflowStatus nodeBackflowStatus = this.nodesStatus.get(nodeName);
        if (nodeBackflowStatus == null) {
            nodeBackflowStatus = new NodeBackflowStatus(nodeName);
            this.nodesStatus.put(nodeName, nodeBackflowStatus);
        }
        return nodeBackflowStatus;
    }

    @Override
    public IProcessDetailStatus<NodeBackflowStatus> getProcessStatus() {
        return new IProcessDetailStatus<NodeBackflowStatus>(){

            @Override
            public Collection<NodeBackflowStatus> getDetails() {
                if (IndexBackFlowPhaseStatus.this.nodesStatus.isEmpty()) {
                    NodeBackflowStatus mock = new NodeBackflowStatus("");
                    mock.setWaiting(true);
                    return Collections.singleton(mock);
                }
                return IndexBackFlowPhaseStatus.this.nodesStatus.values();
            }

            @Override
            public int getProcessPercent() {
                int allrow = 0;
                for (NodeBackflowStatus s : IndexBackFlowPhaseStatus.this.nodesStatus.values()) {
                    allrow = (int)((long)allrow + s.getAllSize());
                }
                if (allrow < 1) {
                    return 0;
                }
                double weight = 0.0;
                double percent = 0.0;
                for (Map.Entry<String, NodeBackflowStatus> entry : IndexBackFlowPhaseStatus.this.nodesStatus.entrySet()) {
                    weight = entry.getValue().getReaded() * 100L / (long)allrow;
                    percent += (double)entry.getValue().getPercent() * weight;
                }
                return (int)(percent / 100.0);
            }

            @Override
            public void detailVisit(IChildProcessStatusVisitor visitor) {
                for (NodeBackflowStatus s : IndexBackFlowPhaseStatus.this.nodesStatus.values()) {
                    visitor.visit(s);
                }
            }
        };
    }

    @Override
    protected Collection<NodeBackflowStatus> getChildStatusNode() {
        return this.nodesStatus.values();
    }

    public static class NodeBackflowStatus
    extends AbstractChildProcessStatus {
        private final String nodeName;
        int allSize;
        int readed;

        public NodeBackflowStatus(String nodeName) {
            this.nodeName = nodeName;
        }

        public long getAllSize() {
            return this.allSize;
        }

        public void setAllSize(int allSize) {
            this.allSize = allSize;
        }

        public long getReaded() {
            return this.readed;
        }

        public void setReaded(int readed) {
            this.readed = readed;
        }

        @Override
        public String getAll() {
            return FileUtils.byteCountToDisplaySize((long)this.allSize);
        }

        @Override
        public String getProcessed() {
            return FileUtils.byteCountToDisplaySize((long)this.readed);
        }

        @Override
        public int getPercent() {
            if (this.allSize < 1) {
                return 0;
            }
            return (int)((float)this.readed * 1.0f / (float)this.allSize * 100.0f);
        }

        @Override
        public String getName() {
            return this.nodeName;
        }
    }
}

