/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.phasestatus.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.fullbuild.phasestatus.IFlush2Local;
import com.qlangtech.tis.fullbuild.phasestatus.IProcessDetailStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.AbstractChildProcessStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BasicPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.ProcessDetailStatusImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DumpPhaseStatus
extends BasicPhaseStatus<TableDumpStatus> {
    @JSONField(serialize=false)
    public final Map<String, TableDumpStatus> tablesDump = Maps.newConcurrentMap();

    public DumpPhaseStatus(int taskid) {
        super(taskid);
    }

    public DumpPhaseStatus(int taskid, IFlush2Local statusWriter) {
        super(taskid, statusWriter);
    }

    @Override
    protected FullbuildPhase getPhase() {
        return FullbuildPhase.FullDump;
    }

    @Override
    public boolean isShallOpen() {
        return DumpPhaseStatus.shallOpenView(this.tablesDump.values());
    }

    @Override
    protected Collection<TableDumpStatus> getChildStatusNode() {
        return this.tablesDump.values();
    }

    public TableDumpStatus getTable(String tableName) {
        TableDumpStatus tabDumpStatus = this.tablesDump.get(tableName);
        if (tabDumpStatus == null) {
            tabDumpStatus = new TableDumpStatus(tableName, this.getTaskId());
            this.tablesDump.put(tableName, tabDumpStatus);
        }
        return tabDumpStatus;
    }

    @Override
    public IProcessDetailStatus<TableDumpStatus> getProcessStatus() {
        return new ProcessDetailStatusImpl<TableDumpStatus>(this.tablesDump){

            @Override
            protected TableDumpStatus createMockStatus() {
                TableDumpStatus s = new TableDumpStatus("", 1);
                s.setWaiting(true);
                return s;
            }
        };
    }

    public static class TableDumpStatus
    extends AbstractChildProcessStatus {
        private String tableName;
        private int taskid;
        private int allRows;
        private int readRows;

        public TableDumpStatus() {
        }

        public Map<String, String> getDesc(boolean success, String pt) {
            HashMap<String, String> state = new HashMap<String, String>();
            state.put("tabname", this.tableName);
            state.put("all", String.valueOf(this.allRows));
            state.put("readed", String.valueOf(this.readRows));
            state.put("success", String.valueOf(success));
            state.put("pt", pt);
            return state;
        }

        public void setAllRows(int allRows) {
            this.allRows = allRows;
        }

        public TableDumpStatus(String tableName, int taskid) {
            this.tableName = tableName;
            this.taskid = taskid;
        }

        public Integer getTaskid() {
            return this.taskid;
        }

        public int getReadRows() {
            return this.readRows;
        }

        public void setReadRows(int readRows) {
            this.readRows = readRows;
        }

        public int getAllRows() {
            return this.allRows;
        }

        @Override
        public String getAll() {
            return String.valueOf(this.allRows);
        }

        public int getDumpPercent() {
            if (this.isSuccess()) {
                return 100;
            }
            if (this.allRows < 1) {
                return 0;
            }
            return this.readRows * 100 / this.allRows;
        }

        @Override
        public String getProcessed() {
            return String.valueOf(this.readRows);
        }

        @Override
        public int getPercent() {
            return this.getDumpPercent();
        }

        @Override
        public String getName() {
            return this.tableName;
        }
    }
}

