/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.phasestatus.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.fullbuild.phasestatus.IProcessDetailStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BasicPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.ProcessDetailStatusImpl;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BuildPhaseStatus
extends BasicPhaseStatus<BuildSharedPhaseStatus> {
    @JSONField(serialize=false)
    public final Map<String, BuildSharedPhaseStatus> nodeBuildStatus = Maps.newConcurrentMap();
    private final ProcessDetailStatusImpl<BuildSharedPhaseStatus> processDetailStatus = new ProcessDetailStatusImpl<BuildSharedPhaseStatus>(this.nodeBuildStatus){

        @Override
        protected BuildSharedPhaseStatus createMockStatus() {
            BuildSharedPhaseStatus s = new BuildSharedPhaseStatus();
            s.setSharedName("");
            s.setWaiting(true);
            return s;
        }
    };

    public BuildPhaseStatus(int taskid) {
        super(taskid);
    }

    @Override
    protected FullbuildPhase getPhase() {
        return FullbuildPhase.BUILD;
    }

    @Override
    public boolean isShallOpen() {
        return BuildPhaseStatus.shallOpenView(this.nodeBuildStatus.values());
    }

    @Override
    public IProcessDetailStatus<BuildSharedPhaseStatus> getProcessStatus() {
        return this.processDetailStatus;
    }

    public BuildSharedPhaseStatus getBuildSharedPhaseStatus(String sharedName) {
        if (StringUtils.isEmpty((String)sharedName)) {
            throw new IllegalArgumentException("param sharedName can not be null");
        }
        BuildSharedPhaseStatus nBuildStatus = this.nodeBuildStatus.get(sharedName);
        if (nBuildStatus == null) {
            nBuildStatus = new BuildSharedPhaseStatus();
            nBuildStatus.setSharedName(sharedName);
            nBuildStatus.setTaskid(this.getTaskId());
            this.nodeBuildStatus.put(sharedName, nBuildStatus);
        }
        return nBuildStatus;
    }

    @Override
    protected Collection<BuildSharedPhaseStatus> getChildStatusNode() {
        return this.nodeBuildStatus.values();
    }
}

