/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.phasestatus.impl;

import com.google.common.util.concurrent.RateLimiter;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.fullbuild.phasestatus.IChildProcessStatus;
import com.qlangtech.tis.fullbuild.phasestatus.IFlush2Local;
import com.qlangtech.tis.fullbuild.phasestatus.IFlush2LocalFactory;
import com.qlangtech.tis.fullbuild.phasestatus.IPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.AbstractChildProcessStatus;
import com.qlangtech.tis.manage.common.Config;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public abstract class BasicPhaseStatus<T extends IChildProcessStatus>
implements IPhaseStatus<T> {
    private final int taskid;
    private transient boolean hasFlush2Local = false;
    public final transient IFlush2Local statusWriter;
    private final transient RateLimiter intervalWriteLimit = RateLimiter.create((double)0.1);

    public static File getFullBuildPhaseLocalFile(int taskid, FullbuildPhase phase) {
        return new File(Config.getMetaCfgDir(), "df-logs/" + taskid + "/" + Objects.requireNonNull(phase, "param phase can not be null").getName());
    }

    protected abstract FullbuildPhase getPhase();

    protected static boolean shallOpenView(Collection<? extends AbstractChildProcessStatus> childs) {
        if (childs.size() < 1) {
            return false;
        }
        Optional<AbstractChildProcessStatus> find = childs.stream().filter(r -> !r.isComplete() && !r.isWaiting()).findFirst();
        return childs.size() > 0 && find.isPresent();
    }

    public boolean isHasFlush2Local() {
        return this.hasFlush2Local;
    }

    public void setHasFlush2Local(boolean hasFlush2Local) {
        this.hasFlush2Local = hasFlush2Local;
    }

    public BasicPhaseStatus(int taskid, IFlush2Local statusWriter) {
        this.taskid = taskid;
        this.statusWriter = statusWriter;
    }

    public BasicPhaseStatus(int taskid) {
        this.taskid = taskid;
        this.statusWriter = IFlush2LocalFactory.createNew(Thread.currentThread().getContextClassLoader(), BasicPhaseStatus.getFullBuildPhaseLocalFile(taskid, this.getPhase())).orElse(null);
    }

    public abstract boolean isShallOpen();

    protected abstract Collection<T> getChildStatusNode();

    @Override
    public final int getTaskId() {
        return this.taskid;
    }

    @Override
    public final boolean isProcessing() {
        if (this.isComplete()) {
            return false;
        }
        for (IChildProcessStatus ts : this.getChildStatusNode()) {
            if (ts.isWaiting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isFaild() {
        for (IChildProcessStatus ts : this.getChildStatusNode()) {
            if (!ts.isFaild()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isComplete() {
        Collection<T> children = this.getChildStatusNode();
        if (children.isEmpty()) {
            return false;
        }
        for (IChildProcessStatus ts : children) {
            if (ts.isFaild()) {
                this.finalWriteStatus2Local();
                return true;
            }
            if (ts.isComplete()) continue;
            return false;
        }
        this.finalWriteStatus2Local();
        return true;
    }

    private void finalWriteStatus2Local() {
        if (!this.hasFlush2Local) {
            this.writeStatus2Local();
            this.hasFlush2Local = true;
        }
    }

    public boolean intervalWriteStatus2Local() {
        if (this.intervalWriteLimit.tryAcquire()) {
            this.writeStatus2Local();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeStatus2Local() {
        if (this.statusWriter != null) {
            BasicPhaseStatus basicPhaseStatus = this;
            synchronized (basicPhaseStatus) {
                try {
                    this.statusWriter.write(this);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    @Override
    public final boolean isSuccess() {
        Collection<T> children = this.getChildStatusNode();
        if (children.isEmpty()) {
            return false;
        }
        for (IChildProcessStatus ts : children) {
            if (ts.isSuccess()) continue;
            return false;
        }
        return true;
    }
}

