/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.trigger.util.JsonUtil;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.function.BiConsumer;

public class SSEEventWriter
extends FilterWriter {
    private final BiConsumer<SSERunnable.SSEEventType, JSONObject> sseEventConsumer;

    public SSEEventWriter(Writer writer) {
        this(writer, (event, data) -> {});
    }

    public SSEEventWriter(Writer writer, BiConsumer<SSERunnable.SSEEventType, JSONObject> sseEventConsumer) {
        super(writer);
        this.sseEventConsumer = Objects.requireNonNull(sseEventConsumer, "sseEventConsumer can not be null");
    }

    public final void writeSSEEvent(SSERunnable.SSEEventType event, JSONObject data) {
        this.writeSSEEvent(event, JsonUtil.toString(data, false));
        this.sseEventConsumer.accept(event, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeSSEEvent(SSERunnable.SSEEventType event, String data) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.out.write("event: " + event.getEventType() + "\n");
                this.out.write("data: " + data + "\n\n");
                this.out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

