/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.qlangtech.tis.plugin.ds.DBIdentity;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class DataXJobInfo {
    public static final AtomicReference<File> dataXExecutorDir = new AtomicReference<File>(new File("."));
    public static int DATAX_THREAD_PROCESSING_CANCAL_EXITCODE = 943;
    private static final String FILENAME_SPLIT_CHAR = "/";
    private static final String TAB_SPLIT_CHAR = ",";
    private static DataXJobInfo currJobInfo;
    public final String jobFileName;
    private final Optional<String[]> targetTableNames;
    private final DBIdentity dbFactoryId;

    public static DataXJobInfo parse(String jobInfo) {
        String[] split = StringUtils.split((String)jobInfo, (String)FILENAME_SPLIT_CHAR);
        if (split.length > 2) {
            currJobInfo = new DataXJobInfo(split[0], DBIdentity.parseId(split[1]), Optional.of(StringUtils.split((String)split[2], (String)TAB_SPLIT_CHAR)));
            return currJobInfo;
        }
        if (split.length == 2) {
            currJobInfo = new DataXJobInfo(split[0], DBIdentity.parseId(split[1]), Optional.empty());
            return currJobInfo;
        }
        throw new IllegalStateException("illegal jobInfo:" + jobInfo);
    }

    public static DataXJobInfo create(String jobFileName, DBIdentity dbFactoryId, List<String> targetTabs) {
        currJobInfo = new DataXJobInfo(jobFileName, dbFactoryId, targetTabs == null || targetTabs.isEmpty() ? Optional.empty() : Optional.of(targetTabs.toArray(new String[targetTabs.size()])));
        return currJobInfo;
    }

    public static DataXJobInfo getCurrent() {
        return Objects.requireNonNull(currJobInfo, "currJobInfo can not be null");
    }

    public static File getJobPath(File dataxCfgDir, String dbFactoryId, String jobFileName) {
        if (StringUtils.isEmpty((CharSequence)dbFactoryId)) {
            throw new IllegalArgumentException("param dbFactoryId can not be null");
        }
        File dataXCfg = new File(dataxCfgDir, dbFactoryId + File.separator + jobFileName);
        return dataXCfg;
    }

    public static File getDataXExecutorDir() {
        File workDir = dataXExecutorDir.get();
        if (!workDir.exists()) {
            throw new IllegalStateException("workDir is not exist:" + workDir.getAbsolutePath());
        }
        return workDir;
    }

    public File getJobPath(File dataxCfgDir) {
        return DataXJobInfo.getJobPath(dataxCfgDir, this.dbFactoryId.identityValue(), this.jobFileName);
    }

    public DBIdentity getDbFactoryId() {
        return this.dbFactoryId;
    }

    public String serialize() {
        CharSequence[] tabs;
        StringBuffer buffer = new StringBuffer(this.jobFileName);
        buffer.append(FILENAME_SPLIT_CHAR).append(this.dbFactoryId.identityValue());
        if (this.targetTableNames.isPresent() && (tabs = this.targetTableNames.get()).length > 0) {
            buffer.append(FILENAME_SPLIT_CHAR).append(String.join((CharSequence)TAB_SPLIT_CHAR, tabs));
        }
        return buffer.toString();
    }

    public String toString() {
        return this.serialize();
    }

    private DataXJobInfo(String jobFileName, DBIdentity dbFactoryId, Optional<String[]> targetTableName) {
        if (StringUtils.isEmpty((CharSequence)jobFileName)) {
            throw new IllegalArgumentException("param jobFileName can not be empty");
        }
        this.jobFileName = jobFileName;
        this.targetTableNames = targetTableName;
        this.dbFactoryId = dbFactoryId;
    }

    public Optional<String[]> getTargetTableNames() {
        return this.targetTableNames;
    }
}

