/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.compiler.java;

import javax.tools.JavaFileObject;
import org.apache.commons.lang.StringUtils;

public class ZipPath {
    private final String parentPath;
    private final String entryName;
    private final JavaFileObject.Kind sourceKind;

    public ZipPath(String parentPath, String entryName, JavaFileObject.Kind sourceKind) {
        this.parentPath = parentPath;
        this.entryName = entryName;
        this.sourceKind = sourceKind;
    }

    public String getFullSourcePath() {
        StringBuffer result = new StringBuffer(this.getFullPath());
        if (this.sourceKind == JavaFileObject.Kind.CLASS) {
            result.append(JavaFileObject.Kind.CLASS.extension);
        } else if (this.sourceKind == JavaFileObject.Kind.SOURCE) {
            result.append(JavaFileObject.Kind.SOURCE.extension);
        } else if (this.sourceKind == JavaFileObject.Kind.OTHER) {
            result.append(".scala");
        } else {
            throw new IllegalStateException("source kind:" + this.sourceKind + " is illegal");
        }
        return result.toString();
    }

    public String getFullClassPath() {
        return this.getFullPath() + JavaFileObject.Kind.CLASS.extension;
    }

    public String getFullPath() {
        StringBuffer result = new StringBuffer(this.parentPath);
        if (!StringUtils.endsWith((String)this.parentPath, (String)"/")) {
            result.append("/");
        }
        return result.append(this.entryName).toString();
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getEntryName() {
        return this.entryName;
    }
}

