/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.compiler.java;

import com.qlangtech.tis.compiler.java.IOutputEntry;
import com.qlangtech.tis.compiler.java.ZipPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.jar.JarOutputStream;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.apache.commons.lang.StringUtils;

public class NestClassFileObject
extends SimpleJavaFileObject
implements IOutputEntry {
    private ByteArrayOutputStream outPutStream;
    private final ZipPath zipPath;

    public NestClassFileObject(ZipPath zipPath) {
        super(URI.create("file:///mock"), JavaFileObject.Kind.CLASS);
        this.zipPath = zipPath;
    }

    public static NestClassFileObject getNestClassFileObject(String qualifiedClassName, Map<String, IOutputEntry> fileObjects) {
        String pathParent = StringUtils.substringBeforeLast((String)qualifiedClassName, (String)".");
        String className = StringUtils.substringAfterLast((String)qualifiedClassName, (String)".");
        ZipPath zipPath = new ZipPath(StringUtils.replace((String)pathParent, (String)".", (String)"/"), className, JavaFileObject.Kind.CLASS);
        NestClassFileObject fileObj = new NestClassFileObject(zipPath);
        fileObjects.put(qualifiedClassName, fileObj);
        return fileObj;
    }

    @Override
    public boolean containCompiledClass() {
        return true;
    }

    @Override
    public void processSource(JarOutputStream jaroutput) throws Exception {
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.outPutStream = new ByteArrayOutputStream();
        return this.outPutStream;
    }

    @Override
    public ByteArrayOutputStream getOutputStream() throws IOException {
        if (this.outPutStream == null) {
            throw new IllegalStateException("outputStream can not be null");
        }
        return this.outPutStream;
    }

    @Override
    public ZipPath getZipPath() {
        return this.zipPath;
    }

    @Override
    public JavaFileObject getFileObject() {
        return this;
    }
}

