/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.compiler.java;

import com.qlangtech.tis.compiler.java.IOutputEntry;
import com.qlangtech.tis.compiler.java.ZipPath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class MyJavaFileObject
extends SimpleJavaFileObject
implements IOutputEntry {
    private ByteArrayOutputStream outPutStream;
    private File sourceFile;
    private static final Charset utf8 = Charset.forName("utf8");
    private final ZipPath zipPath;
    private final boolean containCompiledClass;

    public MyJavaFileObject(File file, ZipPath zipPath, JavaFileObject.Kind sourceKind, boolean containCompiledClass) {
        super(file.toURI(), sourceKind);
        this.sourceFile = file;
        this.zipPath = zipPath;
        this.containCompiledClass = containCompiledClass;
    }

    @Override
    public boolean containCompiledClass() {
        return this.containCompiledClass;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void processSource(JarOutputStream jaroutput) throws Exception {
        JarEntry entry = new JarEntry(this.zipPath.getFullSourcePath());
        entry.setTime(System.currentTimeMillis());
        try (FileInputStream sourceInput = FileUtils.openInputStream((File)this.sourceFile);){
            jaroutput.putNextEntry(entry);
            IOUtils.copy((InputStream)sourceInput, (OutputStream)jaroutput);
            jaroutput.closeEntry();
        }
    }

    @Override
    public JavaFileObject getFileObject() {
        return this;
    }

    @Override
    public ZipPath getZipPath() {
        return this.zipPath;
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new InputStreamReader((InputStream)FileUtils.openInputStream((File)this.sourceFile), utf8);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return FileUtils.readFileToString((File)this.sourceFile, (Charset)utf8);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.outPutStream = new ByteArrayOutputStream();
        return this.outPutStream;
    }

    @Override
    public ByteArrayOutputStream getOutputStream() throws IOException {
        if (this.outPutStream == null) {
            throw new IllegalStateException("outputStream can not be null,source file:" + this.sourceFile.getAbsolutePath());
        }
        return this.outPutStream;
    }

    public byte[] getCompiledBytes() {
        if (this.outPutStream == null) {
            throw new IllegalStateException("outPutStream can not be null");
        }
        return this.outPutStream.toByteArray();
    }
}

