/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.compiler.java;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.compiler.java.IOutputEntry;
import com.qlangtech.tis.compiler.java.MyJavaFileObject;
import com.qlangtech.tis.compiler.java.ResourcesFile;
import com.qlangtech.tis.compiler.java.SourceGetterStrategy;
import com.qlangtech.tis.compiler.java.ZipPath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import javax.tools.JavaFileObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class FileObjectsContext {
    public Map<String, IOutputEntry> classMap = Maps.newHashMap();
    Set<String> dirSet = Sets.newHashSet();
    public List<ResourcesFile> resources = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traversingFiles(Stack<String> childPath, File parent, FileObjectsContext result, IProcessFile fileProcess) {
        try {
            if (parent == null || !parent.exists()) {
                throw new IllegalStateException("parent is not exist:" + parent.getAbsolutePath());
            }
            File child = null;
            for (String c : parent.list()) {
                child = new File(parent, c);
                if (child.isDirectory()) {
                    childPath.push(c);
                    try {
                        result.dirSet.add(childPath.stream().collect(Collectors.joining("/")));
                        FileObjectsContext.traversingFiles(childPath, child, result, fileProcess);
                        continue;
                    }
                    finally {
                        childPath.pop();
                    }
                }
                String zipPath = childPath.stream().collect(Collectors.joining("/"));
                fileProcess.process(zipPath, child);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FileObjectsContext getFileObjects(File sourceRootDir, SourceGetterStrategy sourceGetterStrategy) {
        FileObjectsContext result = new FileObjectsContext();
        Stack<String> childPath = new Stack<String>();
        FileObjectsContext.traversingFiles(childPath, new File(sourceRootDir, sourceGetterStrategy.childSourceDir), result, (zp, child) -> {
            if (StringUtils.endsWith((String)child.getName(), (String)sourceGetterStrategy.sourceCodeExtendsion)) {
                boolean isJavaSourceCode = sourceGetterStrategy.sourceCodeExtendsion.equals(JavaFileObject.Kind.SOURCE.extension);
                String className = StringUtils.substringBefore((String)child.getName(), (String)".");
                ZipPath zipPath = new ZipPath(zp, className, isJavaSourceCode ? JavaFileObject.Kind.SOURCE : JavaFileObject.Kind.OTHER);
                result.classMap.put(childPath.stream().collect(Collectors.joining(".")) + "." + className, sourceGetterStrategy.processMyJavaFileObject(new MyJavaFileObject(child, zipPath, sourceGetterStrategy.getSourceKind(), isJavaSourceCode)));
            }
        });
        File resourceDir = new File(sourceRootDir, "resources");
        if (sourceGetterStrategy.getResource && resourceDir.exists()) {
            FileObjectsContext.traversingFiles(childPath, resourceDir, result, (zp, child) -> {
                if (StringUtils.endsWith((String)child.getName(), (String)".xml")) {
                    result.resources.add(new ResourcesFile(new ZipPath(zp, child.getName(), JavaFileObject.Kind.OTHER), FileUtils.readFileToByteArray((File)child)));
                }
            });
        }
        return result;
    }

    public static void packageJar(File targetJarFile, FileObjectsContext ... fileObjectsArry) throws Exception {
        FileObjectsContext.packageJar(targetJarFile, new Manifest(), fileObjectsArry);
    }

    public static void packageJar(File targetJarFile, Manifest man, FileObjectsContext ... fileObjectsArry) throws Exception {
        try {
            HashSet savedEntryPaths = Sets.newHashSet();
            try (JarOutputStream jaroutput = new JarOutputStream((OutputStream)FileUtils.openOutputStream((File)targetJarFile), man);){
                for (FileObjectsContext fileObjects : fileObjectsArry) {
                    fileObjects.dirSet.stream().forEach(p -> {
                        try {
                            JarEntry entry = new JarEntry(p + "/");
                            entry.setTime(System.currentTimeMillis());
                            if (savedEntryPaths.add(entry.getName())) {
                                jaroutput.putNextEntry(entry);
                                jaroutput.closeEntry();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                for (FileObjectsContext fileObjects : fileObjectsArry) {
                    for (IOutputEntry f : fileObjects.classMap.values()) {
                        if (f.containCompiledClass()) {
                            FileObjectsContext.writeJarEntry(jaroutput, f);
                        }
                        f.processSource(jaroutput);
                    }
                }
                for (FileObjectsContext fileObjects : fileObjectsArry) {
                    for (ResourcesFile res : fileObjects.resources) {
                        JarEntry entry = new JarEntry(res.getZipPath().getFullPath());
                        if (!savedEntryPaths.add(entry.getName())) continue;
                        entry.setTime(System.currentTimeMillis());
                        byte[] data = res.getContent();
                        entry.setSize(data.length);
                        CRC32 crc = new CRC32();
                        crc.update(data);
                        entry.setCrc(crc.getValue());
                        jaroutput.putNextEntry(entry);
                        jaroutput.write(data);
                        jaroutput.closeEntry();
                    }
                }
                jaroutput.flush();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("jarFileName:" + targetJarFile.getAbsolutePath(), e);
        }
    }

    private static void writeJarEntry(JarOutputStream jarOutput, IOutputEntry fileObj) throws IOException, FileNotFoundException {
        ZipPath zipPath = fileObj.getZipPath();
        JarEntry entry = new JarEntry(zipPath.getFullClassPath());
        entry.setTime(System.currentTimeMillis());
        byte[] data = fileObj.getOutputStream().toByteArray();
        entry.setSize(data.length);
        CRC32 crc = new CRC32();
        crc.update(data);
        entry.setCrc(crc.getValue());
        jarOutput.putNextEntry(entry);
        jarOutput.write(data);
        jarOutput.closeEntry();
    }

    public static interface IProcessFile {
        public void process(String var1, File var2) throws Exception;
    }
}

