/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.cloud;

import com.qlangtech.tis.cloud.ICoordinator;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.TisUTF8;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ITISCoordinator
extends ICoordinator {
    public static final Logger logger = LoggerFactory.getLogger(ITISCoordinator.class);
    public static final AtomicBoolean _shallConnect2RemoteIncrStatusServer = new AtomicBoolean(true);

    public static void disableRemoteServer() {
        _shallConnect2RemoteIncrStatusServer.set(false);
    }

    public static void main(String[] args) {
        _shallConnect2RemoteIncrStatusServer.set(false);
    }

    public static ITISCoordinator create() {
        return ITISCoordinator.create(true, Optional.empty());
    }

    public static ITISCoordinator create(boolean shallConnect2RemoteIncrStatusServer, final Optional<String> assembleHost) {
        if (!shallConnect2RemoteIncrStatusServer) {
            ITISCoordinator.disableRemoteServer();
        }
        logger.info("isDisableGrpcRemoteServerConnect:{}", (Object)(!shallConnect2RemoteIncrStatusServer ? 1 : 0));
        logger.info("create ITISCoordinator with Standalone Mode");
        return new ITISCoordinator(){
            private final String DEFAULT_CHILD1_PATH = "child001";

            @Override
            public List<String> getChildren(String zkPath, boolean b) {
                if ("/tis/incr-transfer-group/incr-state-collect".equals(zkPath)) {
                    return Collections.singletonList("child001");
                }
                throw new IllegalStateException("zkPath:" + zkPath + " is illegal");
            }

            @Override
            public void addOnReconnect(IOnReconnect onReconnect) {
            }

            @Override
            public byte[] getData(String s, boolean b) {
                if (StringUtils.equals((String)s, (String)"/tis/incr-transfer-group/incr-state-collect/child001")) {
                    return ((String)((Object)assembleHost.orElse(Config.getAssembleHost() + ":56432"))).getBytes(TisUTF8.get());
                }
                throw new IllegalStateException("zkPath:" + s + " is illegal");
            }

            @Override
            public void create(String path, byte[] data, boolean persistent, boolean sequential) {
            }

            @Override
            public boolean exists(String path, boolean watch) {
                return true;
            }

            public <T> T unwrap() {
                return null;
            }
        };
    }

    default public boolean shallConnect2RemoteIncrStatusServer() {
        return _shallConnect2RemoteIncrStatusServer.get();
    }

    public List<String> getChildren(String var1, boolean var2);

    public void addOnReconnect(IOnReconnect var1);

    public byte[] getData(String var1, boolean var2);

    public void create(String var1, byte[] var2, boolean var3, boolean var4);

    public boolean exists(String var1, boolean var2);

    public static interface IOnReconnect {
        public void command();
    }
}

