/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.assemble;

public enum ExecResult {
    SUCCESS(1, "\u6210\u529f"),
    FAILD(-1, "\u5931\u8d25"),
    DOING(2, "\u6267\u884c\u4e2d"),
    ASYN_DOING(22, "\u6267\u884c\u4e2d"),
    CANCEL(3, "\u7ec8\u6b62");

    private final int value;
    private final String literal;

    public static ExecResult parse(int value) {
        for (ExecResult r : ExecResult.values()) {
            if (r.value != value) continue;
            return r;
        }
        throw new IllegalStateException("vale:" + value + " is illegal");
    }

    public boolean isComplete() {
        return !this.isProcessing();
    }

    public boolean isProcessing() {
        return this == DOING || this == ASYN_DOING;
    }

    private ExecResult(int value, String literal) {
        this.value = value;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public int getValue() {
        return this.value;
    }
}

