/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.trigger.jst;

import com.qlangtech.tis.cloud.dump.DumpJobId;
import com.qlangtech.tis.cloud.dump.DumpJobStatus;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.fs.ITISFileSystem;
import com.qlangtech.tis.manage.common.ConfigFileReader;
import com.qlangtech.tis.manage.common.PropteryGetter;
import com.qlangtech.tis.manage.common.SnapshotDomain;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.trigger.jst.ImportDataProcessInfo;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexBuildJob
implements Callable<BuildResult> {
    public static final String SCHEMA = "schema";
    private static final Logger logger = LoggerFactory.getLogger(AbstractIndexBuildJob.class);
    protected final int groupNum;
    private final ITISFileSystem indexBuildFS;
    private final SnapshotDomain appDomain;
    static int jobid = 0;
    protected final ImportDataProcessInfo state;

    public AbstractIndexBuildJob(IExecChainContext execContext, ImportDataProcessInfo processInfo, int group, SnapshotDomain domain) {
        this.state = processInfo;
        if (StringUtils.isEmpty((String)processInfo.getTimepoint())) {
            throw new IllegalArgumentException("processInfo.getTimepoint() can not be null");
        }
        this.groupNum = group;
        this.indexBuildFS = execContext.getIndexBuildFileSystem();
        this.appDomain = domain;
    }

    @Override
    public BuildResult call() throws Exception {
        try {
            return this.startBuildIndex();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public final BuildResult startBuildIndex() throws Exception {
        String coreName = this.state.getCoreName(this.groupNum);
        String timePoint = this.state.getTimepoint();
        DumpJobStatus status = new DumpJobStatus();
        status.setTimepoint(this.state.getTimepoint());
        status.setDumpType("remote");
        DumpJobId dumpJobId = new DumpJobId("jtIdentifier", jobid++);
        status.setDumpJobID(dumpJobId);
        status.setCoreName(coreName);
        RunEnvironment runtime = RunEnvironment.getSysRuntime();
        long now = System.currentTimeMillis();
        String outPath = this.state.getIndexBuildOutputPath(this.groupNum);
        logger.info("build out path:" + outPath);
        ITISFileSystem fileSystem = this.indexBuildFS;
        this.appDomain.writeResource2fs(fileSystem, coreName, (PropteryGetter)ConfigFileReader.FILE_SCHEMA);
        this.appDomain.writeResource2fs(fileSystem, coreName, ConfigFileReader.FILE_SOLR);
        logger.info("Excute  RemoteDumpJob: Sbumit Remote Job .....  ");
        status.setStartTime(now);
        String serviceName = this.state.getIndexName();
        logger.info("Excute Remote Dump Job Status: Sbumit  ");
        return this.buildSliceIndex(coreName, timePoint, status, outPath, serviceName);
    }

    protected abstract BuildResult buildSliceIndex(String var1, String var2, DumpJobStatus var3, String var4, String var5) throws Exception, IOException, InterruptedException;

    public static class BuildResult {
        private boolean success;
        private final ImportDataProcessInfo processInfo;
        private final int groupIndex;
        private long indexSize;
        public static final Pattern PATTERN_CORE = Pattern.compile("search4(.+?)_shard(\\d+?)_replica(\\d+?)");

        public static BuildResult createFaild() {
            BuildResult buildResult = new BuildResult(Integer.MAX_VALUE, new ImportDataProcessInfo(Integer.valueOf(0), null, null));
            return buildResult.setSuccess(false);
        }

        public static BuildResult clone(BuildResult from) {
            BuildResult buildResult = new BuildResult(from.groupIndex, from.processInfo);
            buildResult.setSuccess(true).setIndexSize(from.indexSize);
            return buildResult;
        }

        public String getTimepoint() {
            return this.processInfo.getTimepoint();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public BuildResult setSuccess(boolean success) {
            this.success = success;
            return this;
        }

        public long getIndexSize() {
            return this.indexSize;
        }

        public void setIndexSize(long indexSize) {
            this.indexSize = indexSize;
        }

        public int getGroupIndex() {
            return this.groupIndex;
        }

        public BuildResult(int group, ImportDataProcessInfo processInfo) {
            this.groupIndex = group;
            this.processInfo = processInfo;
        }
    }
}

