/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.rpc.server;

import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.qlangtech.tis.exec.impl.TrackableExecuteInterceptor;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BuildPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.grpc.IncrStatusGrpc;
import com.qlangtech.tis.grpc.LaunchReportInfo;
import com.qlangtech.tis.grpc.MasterJob;
import com.qlangtech.tis.grpc.PingResult;
import com.qlangtech.tis.grpc.TableSingleDataIndexStatus;
import com.qlangtech.tis.grpc.TopicInfo;
import com.qlangtech.tis.grpc.UpdateCounterMap;
import com.qlangtech.tis.order.center.IAppSourcePipelineController;
import com.qlangtech.tis.realtime.transfer.ListenerStatusKeeper;
import com.qlangtech.tis.realtime.transfer.TableMultiDataIndexStatus;
import com.qlangtech.tis.realtime.yarn.rpc.ConsumeDataKeeper;
import com.qlangtech.tis.realtime.yarn.rpc.IndexJobRunningStatus;
import com.qlangtech.tis.realtime.yarn.rpc.PingResult;
import com.qlangtech.tis.realtime.yarn.rpc.PipelineFlinkTaskId;
import com.qlangtech.tis.realtime.yarn.rpc.impl.YarnStateStatistics;
import com.qlangtech.tis.rpc.grpc.log.LogCollectorClient;
import com.qlangtech.tis.rpc.grpc.log.common.BuildSharedPhaseStatus;
import com.qlangtech.tis.rpc.grpc.log.common.Empty;
import com.qlangtech.tis.rpc.grpc.log.common.JoinTaskStatus;
import com.qlangtech.tis.rpc.grpc.log.common.TableDumpStatus;
import com.qlangtech.tis.rpc.server.IncrStatusClient;
import com.tis.hadoop.rpc.StatusRpcClientFactory;
import io.grpc.stub.StreamObserver;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class IncrStatusUmbilicalProtocolImpl
extends IncrStatusGrpc.IncrStatusImplBase
implements IAppSourcePipelineController {
    private final HashMap<String, ConcurrentHashMap<String, TableMultiDataIndexStatus>> updateCounterStatus = new HashMap();
    private final ConcurrentHashMap<String, TopicInfo> indexTopicInfo = new ConcurrentHashMap();
    private final BlockingQueue<MasterJob> jobQueue = new ArrayBlockingQueue<MasterJob>(100);
    private static final IncrStatusUmbilicalProtocolImpl instance = new IncrStatusUmbilicalProtocolImpl();
    private static final int JOB_EXPIRE_TIME = 30000;
    private static final int TABLE_COUNT_GAP = 5;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public static final Logger log = LoggerFactory.getLogger(IncrStatusUmbilicalProtocolImpl.class);
    public static final Logger statisLog = LoggerFactory.getLogger((String)"statis");
    private static final JsonFormat.Printer jsonPrint = JsonFormat.printer();
    private static final ThreadLocal<SimpleDateFormat> formatYyyyMMddHHmmss = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    public static ExecHook execHook = new ExecHook();
    private static final TopicInfo NULL_TOPIC_INFO;
    private boolean startLogging = false;

    public static IncrStatusUmbilicalProtocolImpl getInstance() {
        return instance;
    }

    private IncrStatusUmbilicalProtocolImpl() {
    }

    public void reportJoinStatus(JoinTaskStatus joinStat, StreamObserver<Empty> responseObserver) {
        int taskid = joinStat.getTaskid();
        PhaseStatusCollection phaseStatusSet = TrackableExecuteInterceptor.getTaskPhaseReference(taskid);
        if (phaseStatusSet == null) {
            this.returnEmpty(responseObserver);
            return;
        }
        log.info("taskid:" + taskid + ",tablename:" + joinStat.getJoinTaskName() + ",compile:" + joinStat.getComplete() + ",faild:" + joinStat.getFaild());
        JoinPhaseStatus joinPhase = phaseStatusSet.getJoinPhase();
        JoinPhaseStatus.JoinTaskStatus joinTskStatus = LogCollectorClient.convert((JoinTaskStatus)joinStat);
        joinPhase.taskStatus.put(joinStat.getJoinTaskName(), joinTskStatus);
        joinPhase.isComplete();
        phaseStatusSet.flushStatus2Local();
        this.returnEmpty(responseObserver);
    }

    public void ping(Empty request, StreamObserver<com.qlangtech.tis.grpc.PingResult> responseObserver) {
        PingResult result = new PingResult();
        PingResult.Builder builder = com.qlangtech.tis.grpc.PingResult.newBuilder();
        builder.setValue(result.getValue());
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void reportStatus(UpdateCounterMap updateCounter, StreamObserver<MasterJob> responseObserver) {
        String from = updateCounter.getFrom();
        long updateTime = ConsumeDataKeeper.getCurrentTimeInSec();
        PipelineFlinkTaskId pipeFlinkTaskIdKey = null;
        for (Map.Entry entry : updateCounter.getDataMap().entrySet()) {
            pipeFlinkTaskIdKey = PipelineFlinkTaskId.parse((String)((String)entry.getKey()));
            pipeFlinkTaskIdKey.getPipeline();
            ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums.create((long)updateCounter.getGcCounter());
            TableSingleDataIndexStatus updateCounterFromClient = (TableSingleDataIndexStatus)entry.getValue();
            String uuid = updateCounterFromClient.getUuid();
            TableMultiDataIndexStatus tableMultiDataIndexStatus = this.getAppSubExecNodeMetrixStatus(pipeFlinkTaskIdKey, uuid);
            tableMultiDataIndexStatus.setBufferQueueRemainingCapacity(updateCounterFromClient.getBufferQueueRemainingCapacity());
            tableMultiDataIndexStatus.setConsumeErrorCount(updateCounterFromClient.getConsumeErrorCount());
            tableMultiDataIndexStatus.setIgnoreRowsCount(updateCounterFromClient.getIgnoreRowsCount());
            tableMultiDataIndexStatus.setUUID(uuid);
            tableMultiDataIndexStatus.setFromAddress(from);
            tableMultiDataIndexStatus.setUpdateTime(updateTime);
            tableMultiDataIndexStatus.setIncrProcessPaused(updateCounterFromClient.getIncrProcessPaused());
            tableMultiDataIndexStatus.setIncrRateLimitConfig(ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums.create((long)updateCounterFromClient.getTis30SAvgRT()));
            for (Map.Entry tabUpdate : updateCounterFromClient.getTableConsumeDataMap().entrySet()) {
                tableMultiDataIndexStatus.put((String)tabUpdate.getKey(), new ConsumeDataKeeper(((Long)tabUpdate.getValue()).longValue(), updateTime));
            }
        }
        MasterJob masterJob = this.pollJob(updateCounter);
        if (masterJob != null) {
            responseObserver.onNext((Object)masterJob);
        } else {
            responseObserver.onNext((Object)MasterJob.newBuilder().setJobType(MasterJob.JobType.None).build());
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMultiDataIndexStatus getAppSubExecNodeMetrixStatus(PipelineFlinkTaskId pipeFlinkTaskIdKey, String subExecNodeId) {
        ConcurrentHashMap indexStatus = this.updateCounterStatus.get(pipeFlinkTaskIdKey.getPipeline());
        if (indexStatus == null) {
            HashMap<String, ConcurrentHashMap<String, TableMultiDataIndexStatus>> hashMap = this.updateCounterStatus;
            synchronized (hashMap) {
                indexStatus = this.updateCounterStatus.computeIfAbsent(pipeFlinkTaskIdKey.getPipeline(), k -> new ConcurrentHashMap());
            }
        }
        if (!StringUtils.equals((String)subExecNodeId, (String)pipeFlinkTaskIdKey.getTaskId())) {
            throw new IllegalStateException("subExecNodeId:" + subExecNodeId + ",must equal with:" + pipeFlinkTaskIdKey.getTaskId());
        }
        TableMultiDataIndexStatus tableMultiDataIndexStatus = indexStatus.get(subExecNodeId);
        if (tableMultiDataIndexStatus == null) {
            tableMultiDataIndexStatus = indexStatus.computeIfAbsent(subExecNodeId, k -> new TableMultiDataIndexStatus());
        }
        return tableMultiDataIndexStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeLaunchReport(LaunchReportInfo launchReportInfo, StreamObserver<Empty> responseObserver) {
        try {
            ConcurrentHashMap<String, TopicInfo> concurrentHashMap = this.indexTopicInfo;
            synchronized (concurrentHashMap) {
                for (Map.Entry entry : launchReportInfo.getCollectionFocusTopicInfoMap().entrySet()) {
                    this.indexTopicInfo.put((String)entry.getKey(), (TopicInfo)entry.getValue());
                    log.info("collection:" + (String)entry.getKey() + " topicfocuse:" + jsonPrint.print((MessageOrBuilder)entry.getValue()));
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        this.returnEmpty(responseObserver);
    }

    public void reportDumpTableStatus(DumpPhaseStatus.TableDumpStatus tableDumpStatus) {
        this.reportDumpTableStatus(IncrStatusClient.convert((DumpPhaseStatus.TableDumpStatus)tableDumpStatus), (StreamObserver<Empty>)new StatusRpcClientFactory.NoopStreamObserver());
    }

    public void reportBuildIndexStatErr(int taskid, String shardName) {
        execHook.reportBuildIndexStatErr(taskid, shardName);
        BuildSharedPhaseStatus.Builder builder = com.qlangtech.tis.rpc.grpc.log.common.BuildSharedPhaseStatus.newBuilder();
        builder.setTaskid(taskid);
        builder.setSharedName(shardName);
        builder.setFaild(true);
        builder.setComplete(true);
        builder.setWaiting(false);
        this.reportBuildIndexStatus(builder.build(), (StreamObserver<Empty>)new StatusRpcClientFactory.NoopStreamObserver());
    }

    public void reportDumpTableStatus(TableDumpStatus tableDumpStatus, StreamObserver<Empty> responseObserver) {
        Integer taskid = tableDumpStatus.getTaskid();
        if (taskid == null || taskid < 1) {
            throw new IllegalArgumentException("taskid illegal:" + taskid);
        }
        PhaseStatusCollection phaseStatusSet = TrackableExecuteInterceptor.getTaskPhaseReference(taskid);
        if (phaseStatusSet == null) {
            this.returnEmpty(responseObserver);
            return;
        }
        log.info("taskid:" + taskid + ",tablename:" + tableDumpStatus.getTableName() + ",read:" + tableDumpStatus.getReadRows() + ",all:" + tableDumpStatus.getAllRows());
        DumpPhaseStatus dumpPhase = phaseStatusSet.getDumpPhase();
        DumpPhaseStatus.TableDumpStatus dumpStatus = dumpPhase.getTable(tableDumpStatus.getTableName());
        if (tableDumpStatus.getComplete()) {
            dumpStatus.setComplete(true);
        }
        if (tableDumpStatus.getFaild()) {
            dumpStatus.setFaild(true);
        }
        dumpStatus.setReadRows(tableDumpStatus.getReadRows());
        dumpStatus.setAllRows(tableDumpStatus.getAllRows());
        if (!tableDumpStatus.getWaiting()) {
            dumpStatus.setWaiting(tableDumpStatus.getWaiting());
        }
        dumpPhase.isComplete();
        phaseStatusSet.flushStatus2Local();
        this.returnEmpty(responseObserver);
    }

    private void returnEmpty(StreamObserver<Empty> responseObserver) {
        responseObserver.onNext((Object)Empty.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void reportBuildIndexStatus(com.qlangtech.tis.rpc.grpc.log.common.BuildSharedPhaseStatus buildStatus, StreamObserver<Empty> responseObserver) {
        Integer taskid = buildStatus.getTaskid();
        if (taskid == null) {
            throw new IllegalArgumentException("taskid can not be null");
        }
        PhaseStatusCollection phaseStatusSet = TrackableExecuteInterceptor.getTaskPhaseReference(taskid);
        if (phaseStatusSet == null) {
            log.warn("taskid:" + taskid + " relevent phaseStatusSet is null");
            this.returnEmpty(responseObserver);
            return;
        }
        BuildPhaseStatus status = phaseStatusSet.getBuildPhase();
        BuildSharedPhaseStatus sharedBuildStatus = status.getBuildSharedPhaseStatus(buildStatus.getSharedName());
        if (!sharedBuildStatus.isFaild()) {
            sharedBuildStatus.setFaild(buildStatus.getFaild());
        }
        if (!sharedBuildStatus.isComplete()) {
            sharedBuildStatus.setComplete(buildStatus.getComplete());
        }
        if (sharedBuildStatus.isWaiting()) {
            sharedBuildStatus.setWaiting(buildStatus.getWaiting());
        }
        sharedBuildStatus.setAllBuildSize(buildStatus.getAllBuildSize());
        sharedBuildStatus.setBuildReaded(buildStatus.getBuildReaded());
        status.isComplete();
        this.returnEmpty(responseObserver);
    }

    public IndexJobRunningStatus getIndexJobRunningStatus(String collection) {
        return new IndexJobRunningStatus(this.isIncrGoingOn(collection), this.isIncrProcessPaused(collection));
    }

    private boolean isIncrGoingOn(String collection) {
        if (!this.updateCounterStatus.containsKey(collection)) {
            return false;
        }
        ConcurrentHashMap<String, TableMultiDataIndexStatus> indexStatus = this.updateCounterStatus.get(collection);
        return MapUtils.isNotEmpty(indexStatus);
    }

    private boolean isIncrProcessPaused(String collection) {
        ConcurrentHashMap<String, TableMultiDataIndexStatus> indexStatus = this.updateCounterStatus.get(collection);
        if (indexStatus == null || indexStatus.size() < 1) {
            return false;
        }
        for (TableMultiDataIndexStatus status : indexStatus.values()) {
            if (status.isIncrProcessPaused()) continue;
            return false;
        }
        return true;
    }

    public boolean stop(String appName) {
        return this.pauseConsume(appName);
    }

    public boolean resume(String appName) {
        return this.resumeConsume(appName);
    }

    private boolean resumeConsume(String indexName) {
        return this.addJob(indexName, false);
    }

    private boolean pauseConsume(String indexName) {
        return this.addJob(indexName, true);
    }

    private boolean addJob(String indexName, boolean isPaused) {
        if (!this.updateCounterStatus.containsKey(indexName)) {
            log.error(indexName + " doesn't not exist in assemble node");
            return false;
        }
        StringBuffer logContent = new StringBuffer("add job to worker by " + indexName + ",stop:" + isPaused + " nodes:");
        for (String uuid : this.updateCounterStatus.get(indexName).keySet()) {
            MasterJob.Builder masterBuilder = MasterJob.newBuilder();
            masterBuilder.setJobTypeValue(1);
            masterBuilder.setIndexName(indexName);
            masterBuilder.setUuid(uuid);
            masterBuilder.setStop(isPaused);
            masterBuilder.setCreateTime(System.currentTimeMillis());
            this.sendJob2Worker(masterBuilder.build());
            logContent.append(uuid).append(",");
        }
        log.info(logContent.toString());
        return true;
    }

    private void sendJob2Worker(MasterJob job) {
        try {
            this.jobQueue.put(job);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public TopicInfo getFocusTopicInfo(String collection) {
        return this.indexTopicInfo.getOrDefault(collection, NULL_TOPIC_INFO);
    }

    public Map<String, TableMultiDataIndexStatus> getIndexUpdateCounterStatus(String collection) {
        return this.updateCounterStatus.get(collection);
    }

    public void removeIndexUpdateCounterStatus(String collection) {
        this.updateCounterStatus.remove(collection);
        this.indexTopicInfo.remove(collection);
    }

    public void startLogging() {
        if (this.startLogging) {
            return;
        }
        try {
            this.scheduler.scheduleAtFixedRate(() -> {
                try {
                    long currentTimeInSec = ConsumeDataKeeper.getCurrentTimeInSec();
                    for (String indexName : this.updateCounterStatus.keySet()) {
                        ConcurrentHashMap<String, TableMultiDataIndexStatus> indexStatus = this.updateCounterStatus.get(indexName);
                        indexStatus.entrySet().removeIf(entry -> {
                            ConcurrentHashMap<String, TopicInfo> concurrentHashMap = this.indexTopicInfo;
                            synchronized (concurrentHashMap) {
                                boolean expire = ((TableMultiDataIndexStatus)entry.getValue()).isExpire(currentTimeInSec);
                                return expire;
                            }
                        });
                        if (indexStatus.size() <= 0) continue;
                        IncrStatusUmbilicalProtocolImpl.setCollectionName(indexName);
                        this.printLog(indexStatus, currentTimeInSec);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }, 15L, 5L, TimeUnit.SECONDS);
        }
        finally {
            this.startLogging = true;
        }
    }

    public Pair<Map<String, Long>, ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums> getUpdateAbsoluteCountMap(String collection) {
        return this.getTableUpdateCountMap(this.updateCounterStatus.get(collection));
    }

    public Map<String, Long> getRunPipelineIncrAccumulationCount() {
        HashMap result = Maps.newHashMap();
        Map tagAccumulateCount = null;
        for (Map.Entry<String, ConcurrentHashMap<String, TableMultiDataIndexStatus>> entry : this.updateCounterStatus.entrySet()) {
            if (!this.isIncrGoingOn(entry.getKey())) continue;
            tagAccumulateCount = (Map)this.getTableUpdateCountMap(entry.getValue()).getKey();
            result.put(entry.getKey(), tagAccumulateCount.getOrDefault("tableConsumeCount", 0L));
        }
        return result;
    }

    private void printLog(ConcurrentHashMap<String, TableMultiDataIndexStatus> indexStatus, long currentTimeInSec) {
        String dateString = formatYyyyMMddHHmmss.get().format(new Date());
        Map<String, YarnStateStatistics> yarnStateMap = this.getYarnStateMap(indexStatus, currentTimeInSec);
        YarnStateStatistics yarnState = this.getMapCount(yarnStateMap);
        statisLog.info(dateString + ", tbTPS:" + yarnState.getTbTPS() + ", tisTPS:" + yarnState.getSorlTPS() + "\r\ndetail:" + IncrStatusUmbilicalProtocolImpl.getYarnStateString(yarnStateMap) + "tableCount:" + this.getTableUpdateCount(indexStatus));
    }

    private Map<String, YarnStateStatistics> getYarnStateMap(ConcurrentHashMap<String, TableMultiDataIndexStatus> indexStatus, long currentTimeInSec) {
        HashMap<String, YarnStateStatistics> yarnStateMap = new HashMap<String, YarnStateStatistics>();
        String uuid = null;
        TableMultiDataIndexStatus status = null;
        for (Map.Entry<String, TableMultiDataIndexStatus> entry : indexStatus.entrySet()) {
            ConsumeDataKeeper tmpKeeper;
            int i;
            ConsumeDataKeeper start;
            ConsumeDataKeeper last;
            uuid = entry.getKey();
            status = entry.getValue();
            YarnStateStatistics yarnStateStatistics = new YarnStateStatistics();
            yarnStateMap.put(uuid, yarnStateStatistics);
            yarnStateStatistics.setPaused(status.isIncrProcessPaused());
            yarnStateStatistics.setQueueRC(status.getBufferQueueRemainingCapacity());
            yarnStateStatistics.setFrom(status.getFromAddress());
            yarnStateStatistics.setTis30sAvgRT(status.getIncrRateLimitConfig().serialize());
            LinkedList consumeDataKeepers = status.getConsumeDataKeepList("tableConsumeCount");
            if (consumeDataKeepers == null || consumeDataKeepers.size() <= 0) {
                yarnStateStatistics.setTbTPS(0L);
            } else {
                last = (ConsumeDataKeeper)consumeDataKeepers.getLast();
                start = null;
                for (i = consumeDataKeepers.size() - 2; i >= 0 && (tmpKeeper = (ConsumeDataKeeper)consumeDataKeepers.get(i)).getCreateTime() > currentTimeInSec - 5L; --i) {
                    start = tmpKeeper;
                }
                if (start == null) {
                    yarnStateStatistics.setTbTPS(last.getAccumulation() / 5L);
                } else {
                    yarnStateStatistics.setTbTPS((last.getAccumulation() - start.getAccumulation()) / 5L);
                }
            }
            consumeDataKeepers = status.getConsumeDataKeepList("solrConsume");
            if (consumeDataKeepers == null || consumeDataKeepers.size() <= 0) {
                yarnStateStatistics.setTbTPS(0L);
                continue;
            }
            last = (ConsumeDataKeeper)consumeDataKeepers.getLast();
            start = null;
            for (i = consumeDataKeepers.size() - 2; i >= 0 && (tmpKeeper = (ConsumeDataKeeper)consumeDataKeepers.get(i)).getCreateTime() > currentTimeInSec - 5L; --i) {
                start = tmpKeeper;
            }
            if (start == null) {
                yarnStateStatistics.setSorlTPS(last.getAccumulation() / 5L);
                continue;
            }
            yarnStateStatistics.setSorlTPS((last.getAccumulation() - start.getAccumulation()) / 5L);
        }
        return yarnStateMap;
    }

    private YarnStateStatistics getMapCount(Map<String, YarnStateStatistics> yarnStateMap) {
        YarnStateStatistics yarnState = new YarnStateStatistics();
        for (YarnStateStatistics yarnStateStatistics : yarnStateMap.values()) {
            yarnState.setTbTPS(yarnState.getTbTPS() + yarnStateStatistics.getTbTPS());
            yarnState.setSorlTPS(yarnState.getSorlTPS() + yarnStateStatistics.getSorlTPS());
        }
        return yarnState;
    }

    private static String getYarnStateString(Map<String, YarnStateStatistics> yarnStateMap) {
        StringBuilder sb = new StringBuilder("\r\n");
        for (YarnStateStatistics yarnStateStatistics : yarnStateMap.values()) {
            String state = String.format("{'host':'%s'," + (yarnStateStatistics.isPaused() ? " paused ," : "") + "'tbTPS':%d, 'solrTPS':%d, 'solr_30s_avg_rt':%dms, 'queueRC':%d}\r\n", yarnStateStatistics.getFrom(), yarnStateStatistics.getTbTPS(), yarnStateStatistics.getSorlTPS(), yarnStateStatistics.getTis30sAvgRT(), yarnStateStatistics.getQueueRC());
            sb.append(state);
        }
        return sb.toString();
    }

    private MasterJob pollJob(UpdateCounterMap upateCounter) {
        MasterJob job;
        if (this.jobQueue.size() <= 0) {
            return null;
        }
        long nowTime = System.currentTimeMillis();
        while (true) {
            if ((job = (MasterJob)this.jobQueue.peek()) == null) {
                return null;
            }
            if (Math.abs(nowTime - job.getCreateTime()) <= 30000L) break;
            this.jobQueue.poll();
        }
        TableSingleDataIndexStatus singleDataIndexStatus = (TableSingleDataIndexStatus)upateCounter.getDataMap().get(job.getIndexName());
        if (singleDataIndexStatus != null && StringUtils.equals((String)singleDataIndexStatus.getUuid(), (String)job.getUuid()) && this.jobQueue.remove(job)) {
            return job;
        }
        return null;
    }

    public static void setCollectionName(String collectionName) {
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalStateException("app name can not be blank");
        }
        MDC.put((String)"app", (String)collectionName);
    }

    public Map<String, Long> getLastUpdateTimeSec(String index) {
        ConcurrentHashMap<String, TableMultiDataIndexStatus> status = this.updateCounterStatus.get(index);
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, TableMultiDataIndexStatus> entry : status.entrySet()) {
            result.put(entry.getValue().getFromAddress(), entry.getValue().getLastUpdateSec());
        }
        return result;
    }

    private String getTableUpdateCount(ConcurrentHashMap<String, TableMultiDataIndexStatus> indexStatus) {
        if (indexStatus == null || indexStatus.size() <= 0) {
            return "[]";
        }
        StringBuffer desc = new StringBuffer("<<\r\n");
        Map updateCountMap = (Map)this.getTableUpdateCountMap(indexStatus).getKey();
        for (Map.Entry entry : updateCountMap.entrySet()) {
            desc.append("  ").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\r\n");
        }
        desc.append(">>");
        return desc.toString();
    }

    private Pair<Map<String, Long>, ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums> getTableUpdateCountMap(ConcurrentHashMap<String, TableMultiDataIndexStatus> indexStatus) {
        if (indexStatus == null) {
            return Pair.of(Collections.emptyMap(), null);
        }
        HashMap<String, Long> updateCountMap = new HashMap<String, Long>();
        ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums rateLimitConfig = null;
        for (TableMultiDataIndexStatus aIndexStatus : indexStatus.values()) {
            ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums rate = aIndexStatus.getIncrRateLimitConfig();
            if (rateLimitConfig == null || rateLimitConfig.getControllerType().isEmpty()) {
                rateLimitConfig = rate;
            }
            for (String tableName : aIndexStatus.getTableNames()) {
                LinkedList consumeDataKeepers = aIndexStatus.getConsumeDataKeepList(tableName);
                if (consumeDataKeepers.size() < 1) continue;
                long accumulation = ((ConsumeDataKeeper)consumeDataKeepers.getLast()).getAccumulation();
                if (updateCountMap.containsKey(tableName)) {
                    updateCountMap.put(tableName, (Long)updateCountMap.get(tableName) + accumulation);
                    continue;
                }
                updateCountMap.put(tableName, accumulation);
            }
        }
        return Pair.of(updateCountMap, rateLimitConfig);
    }

    public void registerAppSubExecNodeMetrixStatus(String appName, String subExecNodeId) {
        this.getAppSubExecNodeMetrixStatus(new PipelineFlinkTaskId(appName, subExecNodeId), subExecNodeId);
    }

    static {
        TopicInfo.Builder tiBuilder = TopicInfo.newBuilder();
        NULL_TOPIC_INFO = tiBuilder.build();
    }

    public static class ExecHook {
        public void reportDumpTableStatusError(Integer taskid, String fullTableName) {
        }

        public void reportBuildIndexStatErr(int taskid, String shardName) {
        }
    }
}

