/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.rpc.server;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.LoggingEvent;
import com.google.common.collect.Lists;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.exec.impl.TrackableExecuteInterceptor;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.log.RealtimeLoggerCollectorAppender;
import com.qlangtech.tis.order.center.IndexSwapTaskflowLauncher;
import com.qlangtech.tis.rpc.grpc.log.LogCollectorClient;
import com.qlangtech.tis.rpc.grpc.log.common.Empty;
import com.qlangtech.tis.rpc.grpc.log.stream.LogCollectorGrpc;
import com.qlangtech.tis.rpc.grpc.log.stream.PBuildPhaseStatusParam;
import com.qlangtech.tis.rpc.grpc.log.stream.PExecuteState;
import com.qlangtech.tis.rpc.grpc.log.stream.PMonotorTarget;
import com.qlangtech.tis.rpc.grpc.log.stream.PPhaseStatusCollection;
import com.qlangtech.tis.rpc.server.RegisterMonitorEventHook;
import com.qlangtech.tis.trigger.jst.MonotorTarget;
import com.qlangtech.tis.trigger.socket.LogType;
import com.qlangtech.tis.utils.Utils;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.Status;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullBuildStatCollectorServer
extends LogCollectorGrpc.LogCollectorImplBase {
    private static final Logger logger = LoggerFactory.getLogger(FullBuildStatCollectorServer.class);
    private static final FullBuildStatCollectorServer instance = new FullBuildStatCollectorServer();
    public static RegisterMonitorEventHook registerMonitorEventHook = new RegisterMonitorEventHook();

    public static FullBuildStatCollectorServer getInstance() {
        return instance;
    }

    private FullBuildStatCollectorServer() {
    }

    public static void main(String[] args) throws Exception {
        FullBuildStatCollectorServer svc = new FullBuildStatCollectorServer();
        final Server server = ServerBuilder.forPort((int)9999).addService((BindableService)svc).build().start();
        logger.info("Listening on " + server.getPort());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("Shutting down");
                try {
                    server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
            }
        });
        server.awaitTermination();
    }

    public void loadPhaseStatus(PBuildPhaseStatusParam request, StreamObserver<PPhaseStatusCollection> responseObserver) {
        PhaseStatusCollection statusCollection = IndexSwapTaskflowLauncher.loadPhaseStatusFromLocal((int)request.getTaskid());
        logger.info("taskId:{} load relevant status from local persist is null:{}", (Object)request.getTaskid(), (Object)(statusCollection != null ? 1 : 0));
        responseObserver.onNext((Object)(statusCollection != null ? LogCollectorClient.convertPP((PhaseStatusCollection)statusCollection) : null));
        responseObserver.onCompleted();
    }

    public StreamObserver<PMonotorTarget> registerMonitorEvent(final StreamObserver<PExecuteState> responseObserver) {
        registerMonitorEventHook.startSession();
        final ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
        final RealtimeLoggerCollectorAppender.LoggerCollectorAppenderListener listener = new RealtimeLoggerCollectorAppender.LoggerCollectorAppenderListener(){

            public void readLogTailer(RealtimeLoggerCollectorAppender.LoggingEventMeta meta, File logFile) {
                Utils.readLastNLine((File)logFile, (int)300, line -> {
                    if (line == null) {
                        return;
                    }
                    PExecuteState s = this.createLogState(meta, 0L, null, line);
                    responseObserver.onNext((Object)s);
                    registerMonitorEventHook.send2ClientFromFileTailer(logFile, s);
                });
            }

            public void process(RealtimeLoggerCollectorAppender.LoggingEventMeta mtarget, LoggingEvent e) {
                try {
                    String msg = e.getFormattedMessage();
                    if (msg == null) {
                        return;
                    }
                    try (BufferedReader msgReader = new BufferedReader(new StringReader(e.getFormattedMessage()));){
                        String line = null;
                        while ((line = msgReader.readLine()) != null) {
                            PExecuteState s = this.createLogState(mtarget, e.getTimeStamp(), LogCollectorClient.convert((Level)e.getLevel()), line);
                            responseObserver.onNext((Object)s);
                            registerMonitorEventHook.send2Client(s, e);
                        }
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            private PExecuteState createLogState(RealtimeLoggerCollectorAppender.LoggingEventMeta mtarget, long timestamp, PExecuteState.InfoType level, String msg) {
                PExecuteState.Builder serverLog = PExecuteState.newBuilder();
                serverLog.setTime(timestamp);
                if (level != null) {
                    serverLog.setInfoType(level);
                }
                serverLog.setMsg(msg);
                serverLog.setLogType(LogCollectorClient.convert((int)mtarget.logTypeVal));
                if (mtarget.taskid != null) {
                    serverLog.setTaskId((long)mtarget.taskid.intValue());
                }
                return serverLog.build();
            }

            public boolean isClosed() {
                return !serverCallStreamObserver.isReady();
            }
        };
        class OnReadyHandler
        implements Runnable {
            private boolean wasReady = false;

            OnReadyHandler() {
            }

            @Override
            public void run() {
                if (serverCallStreamObserver.isReady() && !this.wasReady) {
                    this.wasReady = true;
                    logger.info("READY");
                }
            }
        }
        final OnReadyHandler onReadyHandler = new OnReadyHandler();
        serverCallStreamObserver.setOnReadyHandler((Runnable)onReadyHandler);
        return new StreamObserver<PMonotorTarget>(){
            {
            }

            public void onNext(PMonotorTarget request) {
                try {
                    MonotorTarget mtarget = LogCollectorClient.convert((PMonotorTarget)request);
                    FullBuildStatCollectorServer.addListener(mtarget, listener);
                    if (!serverCallStreamObserver.isReady()) {
                        onReadyHandler.wasReady = false;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    logger.error(throwable.getMessage(), throwable);
                    responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Error handling request").withCause(throwable).asException());
                }
            }

            public void onError(Throwable t) {
                t.printStackTrace();
                if (!serverCallStreamObserver.isCancelled()) {
                    responseObserver.onCompleted();
                }
            }

            public void onCompleted() {
                logger.info("COMPLETED");
                responseObserver.onCompleted();
                registerMonitorEventHook.closeSession();
            }
        };
    }

    public static String addListener(MonotorTarget mtarget, RealtimeLoggerCollectorAppender.LoggerCollectorAppenderListener listener) {
        StringBuffer targetAppenderName = new StringBuffer();
        RealtimeLoggerCollectorAppender.LoggingEventMeta evtMeta = new RealtimeLoggerCollectorAppender.LoggingEventMeta();
        evtMeta.logTypeVal = mtarget.getLogType().typeKind;
        targetAppenderName.append(mtarget.getLogType().getValue()).append("-");
        if (mtarget.getTaskid() != null) {
            if (mtarget.getLogType() != LogType.FULL) {
                throw new IllegalArgumentException("target logtype:" + mtarget.getLogType() + " is illegal");
            }
            evtMeta.taskid = mtarget.getTaskid();
            targetAppenderName.append(mtarget.getTaskid());
        } else {
            if (mtarget.getLogType() != LogType.INCR_SEND && mtarget.getLogType() != LogType.INCR) {
                throw new IllegalArgumentException("target logtype:" + mtarget.getLogType() + " is illegal");
            }
            evtMeta.collection = mtarget.getCollection().getPipelineName();
            targetAppenderName.append(mtarget.getCollection());
        }
        String target = targetAppenderName.toString();
        RealtimeLoggerCollectorAppender.addListener((String)target, (RealtimeLoggerCollectorAppender.LoggingEventMeta)evtMeta, (RealtimeLoggerCollectorAppender.LoggerCollectorAppenderListener)listener);
        return target;
    }

    public void initTask(PPhaseStatusCollection request, StreamObserver<Empty> responseObserver) {
        ArrayList phaseJudgemment = Lists.newArrayList();
        phaseJudgemment.add(() -> request.getDumpPhase().getTablesDumpCount() > 0 ? FullbuildPhase.FullDump : null);
        phaseJudgemment.add(() -> request.getJoinPhase().getTaskStatusCount() > 0 ? FullbuildPhase.JOIN : null);
        phaseJudgemment.add(() -> request.getBuildPhase().getNodeBuildStatusCount() > 0 ? FullbuildPhase.BUILD : null);
        phaseJudgemment.add(() -> request.getIndexBackFlowPhaseStatus().getNodesStatusCount() > 0 ? FullbuildPhase.IndexBackFlow : null);
        ExecutePhaseRange phaseRange = FullBuildStatCollectorServer.createPhaseRange(phaseJudgemment);
        PhaseStatusCollection statusCollection = LogCollectorClient.convert((PPhaseStatusCollection)request, (ExecutePhaseRange)phaseRange);
        statusCollection.flushStatus2Local();
        TrackableExecuteInterceptor.initialTaskPhase(statusCollection);
        responseObserver.onNext((Object)Empty.newBuilder().build());
        responseObserver.onCompleted();
    }

    private static ExecutePhaseRange createPhaseRange(List<Supplier<FullbuildPhase>> phaseJudgemment) {
        Supplier s;
        Supplier<FullbuildPhase> s2;
        FullbuildPhase start = null;
        FullbuildPhase end = null;
        Iterator<Supplier<FullbuildPhase>> iterator = phaseJudgemment.iterator();
        while (iterator.hasNext() && (start = (s2 = iterator.next()).get()) == null) {
        }
        ArrayList reversed = Lists.newArrayList(phaseJudgemment);
        Collections.reverse(reversed);
        Iterator iterator2 = reversed.iterator();
        while (iterator2.hasNext() && (end = (FullbuildPhase)(s = (Supplier)iterator2.next()).get()) == null) {
        }
        return new ExecutePhaseRange(start, end);
    }

    public void buildPhraseStatus(PBuildPhaseStatusParam request, StreamObserver<PPhaseStatusCollection> responseObserver) {
        int taskid = (int)request.getTaskid();
        logger.info("receive taskid:" + taskid + " ge relevant phaseStatusSet apply");
        ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
        AtomicBoolean wasReady = new AtomicBoolean();
        serverCallStreamObserver.setOnReadyHandler(() -> {
            if (serverCallStreamObserver.isReady() && !wasReady.get()) {
                wasReady.set(true);
                serverCallStreamObserver.request(1);
                PhaseStatusCollection phaseStatusSet = null;
                do {
                    if ((phaseStatusSet = TrackableExecuteInterceptor.getTaskPhaseReference(taskid)) != null) continue;
                    phaseStatusSet = IndexSwapTaskflowLauncher.loadPhaseStatusFromLocal(taskid);
                } while (serverCallStreamObserver.isReady() && this.isStatusNotPresent(phaseStatusSet));
                logger.info("ready to send taskid:" + taskid + "relevant stat info");
                while (serverCallStreamObserver.isReady()) {
                    serverCallStreamObserver.onNext((Object)LogCollectorClient.convertPP((PhaseStatusCollection)phaseStatusSet));
                    if (phaseStatusSet.isComplete()) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                logger.info("stopto monitor taskid:" + taskid + "relevant stat info");
                serverCallStreamObserver.onCompleted();
            }
        });
    }

    private boolean isStatusNotPresent(PhaseStatusCollection phaseStatusSet) {
        boolean isStatusNotPresent;
        boolean bl = isStatusNotPresent = phaseStatusSet == null;
        if (isStatusNotPresent) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return isStatusNotPresent;
    }
}

