/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.rpc.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import com.qlangtech.tis.rpc.grpc.log.appender.LogAppenderGrpc;
import com.qlangtech.tis.rpc.grpc.log.appender.LoggingEvent;
import com.qlangtech.tis.rpc.grpc.log.common.Empty;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DefaultLoggerAppenderServiceImpl
extends LogAppenderGrpc.LogAppenderImplBase {
    private static DefaultLoggerAppenderServiceImpl instance = new DefaultLoggerAppenderServiceImpl();
    private static final Logger logger = LoggerFactory.getLogger(DefaultLoggerAppenderServiceImpl.class);
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();

    public static DefaultLoggerAppenderServiceImpl getInstance() {
        return instance;
    }

    public static Logger getLogger(String name) {
        Logger logger = loggers.get(name);
        if (logger == null) {
            LoggerContext assemble = ContextSelectorStaticBinder.getSingleton().getContextSelector().getLoggerContext("assemble");
            logger = Objects.requireNonNull(assemble, "assemble LoggerContext can not be null").getLogger(name);
            loggers.put(name, logger);
        }
        return logger;
    }

    public void append(LoggingEvent request, StreamObserver<Empty> responseObserver) {
        String logtype;
        Map headers = request.getHeadersMap();
        LoggingEvent.Level level = request.getLevel();
        String execGroup = (String)headers.get("incr_exec_group");
        String application = (String)headers.get("application");
        String host = (String)headers.get("host");
        MDC.put((String)"application", (String)application);
        MDC.put((String)"group", (String)execGroup);
        MDC.put((String)"host", (String)host);
        MDC.put((String)"app", (String)((String)headers.get("app")));
        Object taskid = headers.get("taskid");
        if (taskid != null) {
            MDC.put((String)"taskid", (String)String.valueOf(taskid));
        }
        if (StringUtils.isEmpty((String)(logtype = (String)headers.get("logtype")))) {
            logger.info(request.getBody());
        } else {
            Logger targetLogger = DefaultLoggerAppenderServiceImpl.getLogger(logtype);
            switch (level) {
                case INFO: {
                    targetLogger.info(request.getBody());
                    break;
                }
                case ERROR: {
                    targetLogger.error(request.getBody());
                    break;
                }
                case WARNING: {
                    targetLogger.warn(request.getBody());
                    break;
                }
                default: {
                    throw new IllegalStateException("illegal level:" + level);
                }
            }
        }
        responseObserver.onNext((Object)Empty.newBuilder().build());
        responseObserver.onCompleted();
    }
}

