/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.servlet;

import com.alibaba.fastjson.JSON;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.manage.servlet.IncrTagHeatBeatMonitor;
import com.qlangtech.tis.manage.servlet.TopicTagIncrStatus;
import com.qlangtech.tis.plugin.rate.IndexCollectionConfig;
import com.qlangtech.tis.rpc.server.IncrStatusUmbilicalProtocolImpl;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.qlangtech.tis.trigger.jst.MonotorTarget;
import com.qlangtech.tis.trigger.jst.RegisterMonotorTarget;
import com.qlangtech.tis.trigger.socket.ExecuteState;
import com.qlangtech.tis.trigger.socket.LogType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrControlWebSocketServlet
extends WebSocketServlet {
    private static final Logger logger = LoggerFactory.getLogger(IncrControlWebSocketServlet.class);
    private IncrStatusUmbilicalProtocolImpl incrStatusUmbilicalProtocol;
    private static final ExecutorService executorService = Executors.newCachedThreadPool();

    public void configure(WebSocketServletFactory factory) {
        this.incrStatusUmbilicalProtocol = IncrStatusUmbilicalProtocolImpl.getInstance();
        factory.getPolicy().setIdleTimeout(240000L);
        factory.getPolicy().setAsyncWriteTimeout(-1L);
        factory.setCreator((req, rep) -> new IncrSocket(this.incrStatusUmbilicalProtocol));
    }

    public class IncrSocket
    extends WebSocketAdapter
    implements ILogListener {
        private DataXName collectionName;
        private final IncrStatusUmbilicalProtocolImpl incrStatusUmbilicalProtoco;

        public IncrSocket(IncrStatusUmbilicalProtocolImpl incrStatusUmbilicalProtoco) {
            this.incrStatusUmbilicalProtoco = incrStatusUmbilicalProtoco;
        }

        public void onWebSocketConnect(Session sess) {
            super.onWebSocketConnect(sess);
            this.collectionName = DataXName.createDataXPipeline((String)this.getParameter("collection", Collections.singletonList("dummpCollection")));
            List typies = RegisterMonotorTarget.parseLogTypes((DataXName)this.collectionName, (int)-1, (String)this.getParameter("logtype"));
            this.addMonitor(typies);
        }

        private void addMonitor(List<RegisterMonotorTarget> typies) {
            typies.forEach(t -> {
                try {
                    this.addMonitor((MonotorTarget)t);
                }
                catch (Exception e) {
                    logger.error(t.toString(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }

        private String getParameter(String key) {
            return this.getParameter(key, Collections.emptyList());
        }

        private String getParameter(String key, List<String> dft) {
            Map params = this.getSession().getUpgradeRequest().getParameterMap();
            Iterator<String> iterator = params.getOrDefault(key, dft).iterator();
            if (iterator.hasNext()) {
                String v = iterator.next();
                return v;
            }
            throw new IllegalArgumentException("key:" + key + " relevant val is not exist in request");
        }

        private void addMonitor(MonotorTarget monitorTarget) throws Exception {
            if (monitorTarget.testLogType(new LogType[]{LogType.ALL_RUNNING_PIPELINE_CONSUME_TAGS_STATUS})) {
                executorService.execute(() -> {
                    while (!this.isClosed()) {
                        try {
                            ExecuteState event = ExecuteState.create((LogType)LogType.ALL_RUNNING_PIPELINE_CONSUME_TAGS_STATUS, this.incrStatusUmbilicalProtoco.getRunPipelineIncrAccumulationCount());
                            this.sendMsg2Client(event);
                            Thread.sleep(8000L);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else if (monitorTarget.testLogType(new LogType[]{LogType.MQ_TAGS_STATUS})) {
                HashMap transferTagStatus = new HashMap();
                HashMap binlogTopicTagStatus = new HashMap();
                List<TopicTagIncrStatus.FocusTags> focusTags = this.getFocusTags(this.collectionName.getPipelineName());
                if (focusTags.size() > 0) {
                    TopicTagIncrStatus topicTagIncrStatus = new TopicTagIncrStatus(focusTags);
                    executorService.execute(() -> {
                        IndexCollectionConfig collectionConfig = IndexCollectionConfig.getIndexCollectionConfig((DataXName)this.collectionName);
                        Long collectionInterval = Optional.ofNullable(collectionConfig).map(cfg -> cfg.duration.toMillis()).orElse((long)IndexCollectionConfig.defaultDuration() * 1000L);
                        IncrTagHeatBeatMonitor incrTagHeatBeatMonitor = new IncrTagHeatBeatMonitor(this.incrStatusUmbilicalProtoco, this.collectionName.getPipelineName(), this, transferTagStatus, binlogTopicTagStatus, topicTagIncrStatus, collectionInterval);
                        incrTagHeatBeatMonitor.build();
                    });
                }
            } else {
                throw new IllegalStateException("monitor type:" + monitorTarget + " is illegal");
            }
        }

        public List<TopicTagIncrStatus.FocusTags> getFocusTags(String collectionName) throws MalformedURLException {
            TopicTagIncrStatus.FocusTags focusTags = new TopicTagIncrStatus.FocusTags(collectionName, Collections.singletonList("tableConsumeCount"));
            return Collections.singletonList(focusTags);
        }

        public void sendMsg2Client(Object biz) throws IOException {
            this.sendMsg2Client(JSON.toJSONString((Object)biz, (boolean)false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMsg2Client(String jsonContent) throws IOException {
            IncrSocket incrSocket = this;
            synchronized (incrSocket) {
                if (this.isClosed()) {
                    throw new IllegalStateException("ws conn has closed,jsonContent:" + jsonContent);
                }
                this.getRemote().sendString(jsonContent);
            }
        }

        public void read(Object event) {
        }

        public boolean isClosed() {
            return this.isNotConnected();
        }
    }
}

