/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.servlet;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.grpc.LaunchReportInfoEntry;
import com.qlangtech.tis.grpc.TopicInfo;
import com.qlangtech.tis.realtime.transfer.ListenerStatusKeeper;
import com.qlangtech.tis.realtime.yarn.rpc.JobType;
import com.qlangtech.tis.rpc.server.IncrStatusUmbilicalProtocolImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrControlServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(IncrControlServlet.class);
    private IncrStatusUmbilicalProtocolImpl incrStatusUmbilicalProtocol;

    public void init(ServletConfig config) throws ServletException {
        this.incrStatusUmbilicalProtocol = IncrStatusUmbilicalProtocolImpl.getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String collection = IncrControlServlet.getPipelineName(req);
        JobType jobTpe = IncrControlServlet.getJobType(req);
        if (jobTpe == JobType.IndexJobRunning) {
            throw new UnsupportedEncodingException("incr pause/resume has been abandon");
        }
        if (jobTpe == JobType.QueryIndexJobRunningStatus) {
            this.wirteXml2Client(resp, true, "success execute", this.incrStatusUmbilicalProtocol.getIndexJobRunningStatus(collection));
        } else if (jobTpe == JobType.Collection_TopicTags_status) {
            Pair<Map<String, Long>, ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums> tagCountMap = this.incrStatusUmbilicalProtocol.getUpdateAbsoluteCountMap(collection);
            this.wirteXml2Client(resp, true, "", tagCountMap);
        } else if (jobTpe == JobType.ACTION_getTopicTags) {
            TopicInfo topicInfo = this.incrStatusUmbilicalProtocol.getFocusTopicInfo(collection);
            if (topicInfo == null) {
                throw new IllegalStateException("collection:" + collection + " relevant topicInfo can not be null,please check incr process have launch properly");
            }
            com.qlangtech.tis.realtime.yarn.rpc.TopicInfo convert = new com.qlangtech.tis.realtime.yarn.rpc.TopicInfo();
            for (LaunchReportInfoEntry info : topicInfo.getTopicWithTagsList()) {
                for (String tagName : info.getTagNameList()) {
                    convert.addTag(info.getTopicName(), tagName);
                }
            }
            this.wirteXml2Client(resp, true, "", convert);
        } else if (jobTpe == JobType.PipelineDelete) {
            this.incrStatusUmbilicalProtocol.removeIndexUpdateCounterStatus(collection);
            this.wirteXml2Client(resp, true, "", new Object[0]);
        } else {
            throw new ServletException("action:" + req.getParameter("action") + " is not illegal");
        }
    }

    private static JobType getJobType(HttpServletRequest req) {
        JobType jobTpe = JobType.parseJobType((String)req.getParameter("action"));
        return jobTpe;
    }

    private static String getPipelineName(HttpServletRequest req) throws ServletException {
        String collection = req.getParameter("collection");
        if (StringUtils.isBlank((String)collection)) {
            throw new ServletException("param collection:" + collection + " can not be null");
        }
        return collection;
    }

    protected void wirteXml2Client(HttpServletResponse response, boolean success, String msg, Object ... biz) {
        try {
            response.setContentType("text/json");
            JSONObject json = new JSONObject();
            json.put("success", (Object)success);
            json.put("msg", (Object)msg);
            int i = 0;
            if (i < biz.length) {
                json.put("biz", biz[i]);
            }
            response.getWriter().write(json.toJSONString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

