/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.order.center;

import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.exec.AbstractActionInvocation;
import com.qlangtech.tis.exec.ActionInvocation;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.exec.ExecuteResult;
import com.qlangtech.tis.exec.impl.DefaultChainContext;
import com.qlangtech.tis.fullbuild.phasestatus.IFlush2Local;
import com.qlangtech.tis.fullbuild.phasestatus.IFlush2LocalFactory;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BasicPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BuildPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.IndexBackFlowPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.realtime.transfer.IOnsListenerStatus;
import com.qlangtech.tis.rpc.server.DefaultLoggerAppenderServiceImpl;
import com.qlangtech.tis.rpc.server.FullBuildStatCollectorServer;
import com.qlangtech.tis.rpc.server.IncrStatusServer;
import com.qlangtech.tis.rpc.server.IncrStatusUmbilicalProtocolImpl;
import com.qlangtech.tis.solrj.util.ZkUtils;
import io.grpc.BindableService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSwapTaskflowLauncher
implements Daemon,
ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(IndexSwapTaskflowLauncher.class);
    public static final String KEY_INDEX_SWAP_TASK_FLOW_LAUNCHER = "IndexSwapTaskflowLauncher";
    private ITISCoordinator zkClient;
    private Collection<IOnsListenerStatus> incrChannels;
    private IncrStatusServer incrStatusServer;

    public static void initPhaseStatusStatusWriter() {
    }

    public static IndexSwapTaskflowLauncher getIndexSwapTaskflowLauncher(ServletContext context) {
        IndexSwapTaskflowLauncher result = (IndexSwapTaskflowLauncher)context.getAttribute(KEY_INDEX_SWAP_TASK_FLOW_LAUNCHER);
        if (result == null) {
            throw new IllegalStateException("IndexSwapTaskflowLauncher can not be null in servletContext");
        }
        return result;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public void setZkClient(ITISCoordinator zkClient) {
        this.zkClient = zkClient;
    }

    public ITISCoordinator getZkClient() {
        throw new UnsupportedOperationException();
    }

    public Collection<IOnsListenerStatus> getIncrChannels() {
        return this.incrChannels;
    }

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.afterPropertiesSet();
            this.incrChannels = this.initIncrTransferStateCollect();
            sce.getServletContext().setAttribute(KEY_INDEX_SWAP_TASK_FLOW_LAUNCHER, (Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.setZkClient(ITISCoordinator.create());
    }

    public IncrStatusServer getIncrStatusUmbilicalProtocol() {
        if (this.incrStatusServer == null) {
            throw new IllegalStateException("incrStatusUmbilicalProtocolServer can not be null");
        }
        return this.incrStatusServer;
    }

    private Collection<IOnsListenerStatus> initIncrTransferStateCollect() throws Exception {
        int exportPort = 56432;
        this.incrStatusServer = new IncrStatusServer(56432);
        this.incrStatusServer.addService((BindableService)IncrStatusUmbilicalProtocolImpl.getInstance());
        this.incrStatusServer.addService((BindableService)DefaultLoggerAppenderServiceImpl.getInstance());
        this.incrStatusServer.addService((BindableService)FullBuildStatCollectorServer.getInstance());
        this.incrStatusServer.start();
        ArrayList<IOnsListenerStatus> result = new ArrayList<IOnsListenerStatus>();
        List<IOnsListenerStatus> incrChannels = this.getAllTransferChannel(result);
        ZkUtils.registerAddress2ZK((ITISCoordinator)this.zkClient, (String)"/tis/incr-transfer-group/incr-state-collect", (int)56432);
        IncrStatusUmbilicalProtocolImpl.getInstance().startLogging();
        return incrChannels;
    }

    public List<IOnsListenerStatus> getAllTransferChannel(List<IOnsListenerStatus> result) {
        return result;
    }

    public ExecuteResult startWork(DefaultChainContext chainContext) throws Exception {
        chainContext.rebindLoggingMDCParams();
        ActionInvocation invoke = null;
        ExecutePhaseRange range = chainContext.getExecutePhaseRange();
        logger.info("start component:" + range.getStart() + ",end component:" + range.getEnd());
        Objects.requireNonNull(this.zkClient, "zkClient can not be null");
        chainContext.setZkClient(this.zkClient);
        invoke = AbstractActionInvocation.createExecChain(chainContext);
        ExecuteResult execResult = invoke.invoke();
        if (!execResult.isSuccess()) {
            logger.warn(execResult.getMessage());
        }
        return execResult;
    }

    public void init(DaemonContext context) throws DaemonInitException, Exception {
    }

    public void start() throws Exception {
        this.afterPropertiesSet();
        logger.info("index Swap Task ready");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Exception {
        IndexSwapTaskflowLauncher launcher = new IndexSwapTaskflowLauncher();
        launcher.start();
        IndexSwapTaskflowLauncher indexSwapTaskflowLauncher = launcher;
        synchronized (indexSwapTaskflowLauncher) {
            launcher.wait();
        }
    }

    public void stop() throws Exception {
    }

    public void destroy() {
    }

    public static PhaseStatusCollection loadPhaseStatusFromLocal(int taskid) {
        PhaseStatusCollection result = null;
        FullbuildPhase[] phases = FullbuildPhase.values();
        try {
            File localFile = null;
            block8: for (FullbuildPhase phase : phases) {
                localFile = BasicPhaseStatus.getFullBuildPhaseLocalFile((int)taskid, (FullbuildPhase)phase);
                if (!localFile.exists()) {
                    return result;
                }
                if (result == null) {
                    result = new PhaseStatusCollection(Integer.valueOf(taskid), ExecutePhaseRange.fullRange());
                }
                IFlush2Local flush2Local = (IFlush2Local)IFlush2LocalFactory.createNew((ClassLoader)IndexSwapTaskflowLauncher.class.getClassLoader(), (File)localFile).orElseThrow(() -> new IllegalStateException("flush2Local must be present"));
                BasicPhaseStatus phaseStatus = flush2Local.loadPhase();
                switch (phase) {
                    case FullDump: {
                        result.setDumpPhase((DumpPhaseStatus)phaseStatus);
                        continue block8;
                    }
                    case JOIN: {
                        result.setJoinPhase((JoinPhaseStatus)phaseStatus);
                        continue block8;
                    }
                    case BUILD: {
                        result.setBuildPhase((BuildPhaseStatus)phaseStatus);
                        continue block8;
                    }
                    case IndexBackFlow: {
                        result.setIndexBackFlowPhaseStatus((IndexBackFlowPhaseStatus)phaseStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("taskid:" + taskid, e);
        }
        return result;
    }
}

