/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.servlet;

import com.alibaba.fastjson.annotation.JSONField;
import org.apache.commons.lang.StringUtils;

public class TopicTagStatus {
    private final String topic;
    private final String tag;
    private long count;
    private long incr;
    private long lastUpdateTime;

    @JSONField(serialize=true)
    public String getKey() {
        return this.topic + "." + this.tag;
    }

    public String getTag() {
        return this.tag;
    }

    public TopicTagStatus(String topic, String tag, long count, long lastUpdate) {
        this.topic = topic;
        this.tag = tag;
        this.count = count;
        this.lastUpdateTime = lastUpdate;
    }

    public void merge(TopicTagStatus n) {
        if (!StringUtils.equals((String)this.getKey(), (String)n.getKey())) {
            throw new IllegalArgumentException("key1:" + this.getKey() + ",key2:" + n.getKey() + " is not equal");
        }
        if (n.lastUpdateTime > this.lastUpdateTime) {
            this.lastUpdateTime = n.lastUpdateTime;
        }
    }

    public void setCount(long count) {
        this.incr = this.count > 0L && count > this.count ? count - this.count : 0L;
        this.count = count;
    }

    public long getCount() {
        return this.count;
    }

    @JSONField(serialize=true)
    public long getIncr() {
        return this.incr;
    }

    @JSONField(serialize=true)
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    void clean() {
        this.count = 0L;
        this.incr = 0L;
    }

    public String toString() {
        return "topic:" + this.topic + ",tag:" + this.tag + ",count:" + this.count + ",incr:" + this.incr + ",lastUpdate:" + this.lastUpdateTime;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdateTime = lastUpdate;
    }
}

