/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.servlet;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.manage.servlet.TopicTagStatus;
import com.qlangtech.tis.realtime.transfer.ListenerStatusKeeper;
import com.qlangtech.tis.realtime.yarn.rpc.IncrRateControllerCfgDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class TopicTagIncrStatus {
    public static final List<Pair<String, Function<TopicTagIncr, Integer>>> ALL_SUMMARY_KEYS_PAIR_LIST = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"tableConsumeCount", tagIncr -> tagIncr.getTrantransferIncr()), Pair.of((Object)"tableInsertCount", tagIncr -> tagIncr.getBinlogIncr()), Pair.of((Object)"tableUpdateCount", tagIncr -> tagIncr.getBinlogIncr()), Pair.of((Object)"tableDeleteCount", tagIncr -> tagIncr.getBinlogIncr())});
    public static final List<String> ALL_SUMMARY_KEYS = ALL_SUMMARY_KEYS_PAIR_LIST.stream().map(p -> (String)p.getKey()).collect(Collectors.toList());
    private final List<String> focusTags;
    private final LoadingCache<Long, TopicTagIncrSnapshotStatus> c = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Long, TopicTagIncrSnapshotStatus>(){

        public TopicTagIncrSnapshotStatus load(Long key) throws Exception {
            return TopicTagIncrStatus.this.createTopicTagIncrSnapshotStatus();
        }
    });
    private TopicTagIncrSnapshotStatus lastCreate;

    private TopicTagIncrSnapshotStatus createTopicTagIncrSnapshotStatus() {
        this.lastCreate = new TopicTagIncrSnapshotStatus();
        return this.lastCreate;
    }

    public TopicTagIncrStatus(Collection<FocusTags> focusTags) {
        this.focusTags = focusTags.stream().flatMap(t -> t.getTags().stream()).map(tag -> tag).collect(Collectors.toList());
    }

    public void add(Long timeSerialize, TopicTagIncr tagIncr) {
        try {
            TopicTagIncrSnapshotStatus incrStats = (TopicTagIncrSnapshotStatus)this.c.get((Object)timeSerialize);
            if (incrStats == null) {
                throw new IllegalStateException("timeSerialize:" + timeSerialize + " relevant val can not be null");
            }
            incrStats.incrStatus.put(tagIncr.tag, tagIncr);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public TisIncrStatus getAverageTopicTagIncr(boolean average, boolean test) {
        return new TisIncrStatus(this.process(ALL_SUMMARY_KEYS, average, test), this.process(this.focusTags, average, test));
    }

    protected List<TopicTagIncr> process(List<String> focusTags, boolean average, boolean test) {
        ArrayList<TopicTagIncr> result = new ArrayList<TopicTagIncr>();
        ConcurrentMap timeRangeMap = this.c.asMap();
        int rangeSize = timeRangeMap.size();
        if (rangeSize < 1) {
            return Collections.emptyList();
        }
        int binlogIncrSum = 0;
        int trantransferIncrSum = 0;
        TopicTagIncr lastTagIncr = null;
        TopicTagIncr tagIncrPair = null;
        for (String tag : focusTags) {
            binlogIncrSum = 0;
            trantransferIncrSum = 0;
            lastTagIncr = null;
            for (TopicTagIncrSnapshotStatus stat : timeRangeMap.values()) {
                tagIncrPair = stat.incrStatus.get(tag);
                if (tagIncrPair == null) continue;
                binlogIncrSum += tagIncrPair.binlogIncr;
                trantransferIncrSum += tagIncrPair.trantransferIncr;
            }
            if (this.lastCreate != null && (tagIncrPair = this.lastCreate.incrStatus.get(tag)) != null) {
                lastTagIncr = tagIncrPair;
            }
            result.add(new TopicTagIncr(tag, lastTagIncr != null ? lastTagIncr.binlogIncr : 0, lastTagIncr != null ? lastTagIncr.binlogIncrLastUpdate : 0L, this.calculateTraffic(tag, average, rangeSize, trantransferIncrSum, test)));
        }
        return result;
    }

    private int calculateTraffic(String tag, boolean average, int rangeSize, int binlogIncrSum, boolean test) {
        if (test) {
            return (int)(Math.random() * 100.0);
        }
        rangeSize = rangeSize < 2 ? 1 : rangeSize - 1;
        int result = binlogIncrSum / (average ? rangeSize : 1);
        return result;
    }

    public static class FocusTags {
        private static final Joiner joiner = Joiner.on((String)",").skipNulls();
        private final String topic;
        private Collection<String> tags = new ArrayList<String>();

        public FocusTags(String topic, Collection<String> tags) {
            if (tags.size() < 1) {
                throw new IllegalArgumentException("topic:" + tags + " relevant tags can not be empty");
            }
            this.topic = topic;
            this.tags = tags;
        }

        public Collection<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public String getTopic() {
            return this.topic;
        }

        public String toString() {
            return this.createParams();
        }

        private String createParams() {
            List result = Lists.asList((Object)("topic=" + this.topic), (Object[])this.tags.toArray(new String[0]));
            return joiner.join((Iterable)result);
        }
    }

    public static class TopicTagIncr {
        private static final ThreadLocal<SimpleDateFormat> format = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("HH:mm:ss");
            }
        };
        private final String tag;
        private final int binlogIncr;
        private final long binlogIncrLastUpdate;
        private final int trantransferIncr;

        public String getTag() {
            return this.tag;
        }

        public int getBinlogIncr() {
            return this.binlogIncr;
        }

        public String getLastUpdate() {
            return format.get().format(new Date(this.binlogIncrLastUpdate));
        }

        public int getTrantransferIncr() {
            return this.trantransferIncr;
        }

        public static TopicTagIncr create(String tag, Map<String, TopicTagStatus> transfer) {
            long accumulateCount = 0L;
            long binlogIncrLastUpdate = 0L;
            long trantransferIncr = 0L;
            TopicTagStatus transferTagStat = transfer.get(tag);
            if (transferTagStat != null) {
                binlogIncrLastUpdate = transferTagStat.getLastUpdateTime();
                trantransferIncr = transferTagStat.getIncr();
                accumulateCount = transferTagStat.getCount();
            }
            return new TopicTagIncr(tag, (int)accumulateCount, binlogIncrLastUpdate, (int)trantransferIncr);
        }

        public TopicTagIncr(String tag, int binlogIncr, long binlogIncrLastUpdate, int trantransferIncr) {
            this.tag = tag;
            this.binlogIncr = binlogIncr;
            this.binlogIncrLastUpdate = binlogIncrLastUpdate;
            this.trantransferIncr = trantransferIncr;
        }
    }

    private static final class TopicTagIncrSnapshotStatus {
        private Map<String, TopicTagIncr> incrStatus = Maps.newHashMap();

        private TopicTagIncrSnapshotStatus() {
        }
    }

    public static class TisIncrStatus {
        private final Map<String, Integer> summary;
        private final List<TopicTagIncr> tags;
        private ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums rateLimitState = new ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums(IncrRateControllerCfgDTO.RateControllerType.NoLimitParam, -1);

        TisIncrStatus(List<TopicTagIncr> summary, List<TopicTagIncr> tags) {
            this.summary = Maps.newHashMap();
            if (ALL_SUMMARY_KEYS_PAIR_LIST.size() != summary.size()) {
                throw new IllegalArgumentException("ALL_SUMMARY_KEYS size:" + ALL_SUMMARY_KEYS_PAIR_LIST.size() + " must equal with:" + summary.size());
            }
            Pair<String, Function<TopicTagIncr, Integer>> p = null;
            TopicTagIncr tagIncr = null;
            for (int i = 0; i < summary.size(); ++i) {
                p = ALL_SUMMARY_KEYS_PAIR_LIST.get(i);
                tagIncr = summary.get(i);
                this.summary.put((String)p.getKey(), (Integer)((Function)p.getValue()).apply((Object)tagIncr));
            }
            this.tags = tags;
        }

        public Map<String, Integer> getSummary() {
            return this.summary;
        }

        public List<TopicTagIncr> getTags() {
            return this.tags;
        }

        public int getPerSecRateNums() {
            return this.rateLimitState.getPerSecRateNums();
        }

        public short getControllerType() {
            return this.rateLimitState.getControllerType().map(controlType -> controlType.getTypeToken()).orElseThrow();
        }

        public void setRateLimitConfig(ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums rateLimitState) {
            if (rateLimitState == null) {
                return;
            }
            this.rateLimitState = rateLimitState;
        }
    }
}

