/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.servlet;

import com.qlangtech.tis.manage.servlet.TopicTagIncrStatus;
import com.qlangtech.tis.manage.servlet.TopicTagStatus;
import com.qlangtech.tis.realtime.transfer.ListenerStatusKeeper;
import com.qlangtech.tis.rpc.server.IncrStatusUmbilicalProtocolImpl;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.qlangtech.tis.trigger.socket.ExecuteState;
import com.qlangtech.tis.trigger.socket.LogType;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrTagHeatBeatMonitor {
    private static final Logger logger = LoggerFactory.getLogger(IncrTagHeatBeatMonitor.class);
    private final ILogListener messagePush;
    private final Map<String, TopicTagStatus> transferTagStatus;
    private final Map<String, TopicTagStatus> binlogTopicTagStatus;
    private final TopicTagIncrStatus topicTagIncrStatus;
    private final String collectionName;
    private final Long collectionInterval;
    private final IncrStatusUmbilicalProtocolImpl incrStatusUmbilicalProtoco;

    public IncrTagHeatBeatMonitor(IncrStatusUmbilicalProtocolImpl incrStatusUmbilicalProtoco, String collectionName, ILogListener messagePush, Map<String, TopicTagStatus> transferTagStatus, Map<String, TopicTagStatus> binlogTopicTagStatus, TopicTagIncrStatus topicTagIncrStatus, Long collectionInterval) {
        this.collectionName = collectionName;
        this.messagePush = messagePush;
        this.transferTagStatus = transferTagStatus;
        this.binlogTopicTagStatus = binlogTopicTagStatus;
        this.topicTagIncrStatus = topicTagIncrStatus;
        this.collectionInterval = Objects.requireNonNull(collectionInterval, "collectionInterval can not be null");
        this.incrStatusUmbilicalProtoco = incrStatusUmbilicalProtoco;
    }

    public void build() {
        Object tagStat = null;
        ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums rateLimitState = null;
        block6: while (true) {
            try {
                while (!this.messagePush.isClosed()) {
                    long currSec = System.currentTimeMillis() / 1000L;
                    rateLimitState = this.getIncrTransferTagUpdateMap(this.transferTagStatus, this.collectionName);
                    for (String summaryKey : TopicTagIncrStatus.ALL_SUMMARY_KEYS) {
                        this.topicTagIncrStatus.add(currSec, TopicTagIncrStatus.TopicTagIncr.create(summaryKey, this.transferTagStatus));
                    }
                    TopicTagIncrStatus.TisIncrStatus averageTopicTagIncr = this.topicTagIncrStatus.getAverageTopicTagIncr(false, false);
                    averageTopicTagIncr.setRateLimitConfig(rateLimitState);
                    ExecuteState event = ExecuteState.create((LogType)LogType.MQ_TAGS_STATUS, (Object)averageTopicTagIncr);
                    this.messagePush.sendMsg2Client((Object)event);
                    try {
                        Thread.sleep(this.collectionInterval);
                        continue block6;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (Exception e) {
                logger.error(this.collectionName, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums getIncrTransferTagUpdateMap(Map<String, TopicTagStatus> transferTagStatus, String collection) throws Exception {
        Pair<Map<String, Long>, ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums> tagCountMap = this.incrStatusUmbilicalProtoco.getUpdateAbsoluteCountMap(collection);
        for (Map.Entry entry : ((Map)tagCountMap.getKey()).entrySet()) {
            this.setMetricCount(transferTagStatus, (String)entry.getKey(), (Long)entry.getValue());
        }
        ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums limitRateConfig = (ListenerStatusKeeper.LimitRateTypeAndRatePerSecNums)tagCountMap.getValue();
        return limitRateConfig;
    }

    private void setMetricCount(Map<String, TopicTagStatus> tagStatus, String tagName, Long count) {
        TopicTagStatus tagStat = tagStatus.get(tagName);
        logger.info("tagName:{},count:{}", (Object)tagName, (Object)count);
        if (tagStat == null) {
            tagStat = new TopicTagStatus("", tagName, count, System.currentTimeMillis());
            tagStatus.put(tagName, tagStat);
        } else {
            tagStat.setCount(count);
            tagStat.setLastUpdate(System.currentTimeMillis());
        }
    }
}

