/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.taskflow;

import com.google.common.collect.Lists;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.fullbuild.taskflow.BasicTask;
import com.qlangtech.tis.fullbuild.taskflow.ITask;
import com.qlangtech.tis.fullbuild.taskflow.ITaskFactory;
import com.qlangtech.tis.fullbuild.taskflow.TaskWorkflow;
import com.qlangtech.tis.fullbuild.taskflow.impl.EndTask;
import com.qlangtech.tis.fullbuild.taskflow.impl.ForkTask;
import com.qlangtech.tis.fullbuild.taskflow.impl.StartTask;
import com.qlangtech.tis.git.GitUtils;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Deprecated
public class WorkflowTaskConfigParser {
    private static final DocumentBuilderFactory schemaDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final XPathFactory xpathFactory = XPathFactory.newInstance();
    public static final MessageFormat PT_DATE_FORMAT = new MessageFormat("{0}-{1}");
    private static final Logger log = LoggerFactory.getLogger(WorkflowTaskConfigParser.class);
    private int partitionSaveCount = 4;
    private final ITaskFactory taskFactory;
    private final IJoinRuleStreamGetter joinRuleGetter;
    private IExecChainContext tplContext;
    private final JoinPhaseStatus joinPhaseStatus;

    WorkflowTaskConfigParser(ITaskFactory hiveTaskFactory, IJoinRuleStreamGetter joinRuleGetter, JoinPhaseStatus joinPhaseStatus) {
        this.taskFactory = hiveTaskFactory;
        this.joinRuleGetter = joinRuleGetter;
        this.joinPhaseStatus = joinPhaseStatus;
    }

    public static WorkflowTaskConfigParser getInstance(IExecChainContext context, JoinPhaseStatus joinPhaseStatus) {
        throw new UnsupportedOperationException();
    }

    public static WorkflowTaskConfigParser getInstance(String workflowName, GitUtils.GitBranchInfo branch) {
        throw new UnsupportedOperationException();
    }

    public void startJoinSubTables(IJoinTaskContext tplContext) throws Exception {
    }

    public TaskWorkflow getWorkflow() throws Exception {
        String joinTask = this.joinRuleGetter.getTaskContent(this.tplContext);
        Pattern p = Pattern.compile("\\$\\{.?+\\}");
        Matcher m = p.matcher(joinTask);
        TaskWorkflow taskList = this.parseTask(m.replaceAll("test"));
        return taskList;
    }

    private void traverseTask(IExecChainContext execContext, ProcessTask taskProcess) throws Exception {
        TaskWorkflow tasks = this.parseTask(this.joinRuleGetter.getTaskContent(execContext));
        for (ITask iTask : tasks.getAllTask()) {
            taskProcess.process(iTask);
        }
    }

    private TaskWorkflow parseTask(String taskContent) throws Exception {
        DocumentBuilder builder = schemaDocumentBuilderFactory.newDocumentBuilder();
        builder.setEntityResolver((publicId, systemId) -> {
            InputSource source = new InputSource();
            source.setCharacterStream(new StringReader(""));
            return source;
        });
        Document document = builder.parse(new ByteArrayInputStream(taskContent.getBytes()));
        XPath xpath = xpathFactory.newXPath();
        this.setPartitionSaveCount(document, xpath);
        String expression = "/execute/task|/execute/fork|/execute/start|/execute/end|/execute/joinTask|/execute/unionTask";
        NodeList nodes = (NodeList)xpath.evaluate("/execute/task|/execute/fork|/execute/start|/execute/end|/execute/joinTask|/execute/unionTask", document, XPathConstants.NODESET);
        return this.parse(nodes);
    }

    private void setPartitionSaveCount(Document document, XPath xpath) throws XPathExpressionException {
        Node execNode = (Node)xpath.evaluate("/execute", document, XPathConstants.NODE);
        String partitionSaveCount = WorkflowTaskConfigParser.getAttr(execNode, "partitionSaveCount", null, true);
        if (StringUtils.isNotBlank((String)partitionSaveCount)) {
            this.partitionSaveCount = Integer.parseInt(partitionSaveCount);
        }
    }

    public TaskWorkflow parse(NodeList nodes) throws Exception {
        TaskWorkflow taskManager = new TaskWorkflow();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String taskname = this.getTaskName(node);
            BasicTask task = null;
            if ("start".equals(node.getNodeName())) {
                task = new StartTask();
            } else if ("end".equals(node.getNodeName())) {
                task = new EndTask();
            } else if ("fork".equals(node.getNodeName())) {
                task = new ForkTask();
            } else if (!("task".equals(node.getNodeName()) || "joinTask".equals(node.getNodeName()) || "unionTask".equals(node.getNodeName()))) {
                throw new IllegalStateException("illegal node name:" + node.getNodeName());
            }
            ((BasicTask)task).setName(taskname);
            taskManager.addTask(task);
        }
        taskManager.init();
        return taskManager;
    }

    private List<EntityName> getRequiredTables(Node node) {
        String[] tables;
        ArrayList dumpTables = Lists.newArrayList();
        String requiredTables = WorkflowTaskConfigParser.getAttr(node, "requiredTables", "requiredTables", true);
        for (String t : tables = StringUtils.split((String)requiredTables, (String)",")) {
            dumpTables.add(EntityName.parse((String)t));
        }
        return dumpTables;
    }

    protected String getTaskName(Node node) {
        return WorkflowTaskConfigParser.getAttr(node, "name", "name", true);
    }

    private String getSuccessTo(Node node) {
        return WorkflowTaskConfigParser.getAttr(node, "to", "to", true);
    }

    private void setTaskName(BasicTask task, String taskname) {
        task.setName(taskname);
    }

    public static String getAttr(Node node, String name, String missing_err) {
        return WorkflowTaskConfigParser.getAttr(node, name, missing_err, false);
    }

    public static String getAttr(Node node, String name, String missing_err, boolean ignoreNull) {
        Node attr;
        NamedNodeMap attrs = node.getAttributes();
        Node node2 = attr = attrs == null ? null : attrs.getNamedItem(name);
        if (!ignoreNull && attr == null) {
            if (missing_err == null) {
                return null;
            }
            throw new RuntimeException(missing_err + ": missing mandatory attribute '" + name + "'");
        }
        if (attr == null) {
            return null;
        }
        return attr.getNodeValue();
    }

    public IExecChainContext getTplContext() {
        return this.tplContext;
    }

    public void setTplContext(IExecChainContext tplContext) {
        this.tplContext = tplContext;
    }

    public static void main(String[] args) throws Exception {
    }

    static {
        schemaDocumentBuilderFactory.setValidating(false);
    }

    public static interface IJoinRuleStreamGetter {
        public String getTaskContent(IExecChainContext var1);
    }

    public static interface ProcessTask {
        public void process(ITask var1);
    }
}

