/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.taskflow;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.fullbuild.taskflow.BasicTask;
import com.qlangtech.tis.fullbuild.taskflow.TaskDependency;
import com.qlangtech.tis.fullbuild.taskflow.impl.EndTask;
import com.qlangtech.tis.fullbuild.taskflow.impl.ForkTask;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TaskWorkflow {
    final ConcurrentMap<String, TaskDependency> tasksMap = Maps.newConcurrentMap();
    private final ExecutorService forkExecutorService = Executors.newCachedThreadPool();

    public void init() {
        for (TaskDependency task : this.tasksMap.values()) {
            task.init(this);
        }
        System.out.println("=======================================");
        for (TaskDependency task : this.tasksMap.values()) {
            System.out.println(task.getTask().getName() + "->" + task.getPrecondition());
        }
        System.out.println("=======================================");
    }

    public Set<EntityName> getDependenciesTables() {
        HashSet tables = Sets.newHashSet();
        for (TaskDependency task : this.tasksMap.values()) {
            tables.addAll(task.getTask().getDependencyTables());
        }
        return tables;
    }

    public TaskDependency getTaskDependency(String taskname) {
        return (TaskDependency)this.tasksMap.get(taskname);
    }

    public void startExecute(Map<String, Object> params) {
        TaskDependency start = (TaskDependency)this.tasksMap.get("start");
        if (start == null) {
            throw new IllegalStateException("start task have not been defined");
        }
        this.execute(start, params);
        this.findEndTaskAndWaittingStop();
    }

    private void findEndTaskAndWaittingStop() {
        EndTask end = null;
        for (TaskDependency t : this.tasksMap.values()) {
            if (!(t.getTask() instanceof EndTask)) continue;
            if (end == null) {
                end = (EndTask)t.getTask();
                continue;
            }
            throw new IllegalStateException("there is another endtask ,name:" + t.getTask().getName());
        }
        if (end == null) {
            throw new IllegalStateException("end task have not been defined");
        }
        try {
            end.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void execute(TaskDependency task, Map<String, Object> params) {
        if (task.getTask() instanceof ForkTask) {
            ForkTask fork = (ForkTask)task.getTask();
            String[] tos = StringUtils.split((String)fork.getSuccessTo(), (String)",");
            TaskDependency toTask = null;
            for (String to : tos) {
                toTask = (TaskDependency)this.tasksMap.get(to);
                if (toTask == null) {
                    throw new IllegalStateException("to task:'" + to + "' can not be found in taskMap");
                }
                TaskDependency doTask = toTask;
                this.forkExecutorService.execute(() -> {
                    doTask.satisfaction(fork.getName());
                    this.execute(doTask, params);
                });
            }
        } else if (task.exexute(params)) {
            BasicTask t = task.getTask();
            String toTask = t.getSuccessTo();
            if (StringUtils.isBlank((CharSequence)toTask)) {
                return;
            }
            TaskDependency to = (TaskDependency)this.tasksMap.get(toTask);
            if (to != null) {
                to.satisfaction(t.getName());
                this.execute(to, params);
            }
        }
    }

    public List<BasicTask> getAllTask() {
        return this.tasksMap.values().stream().map(r -> r.getTask()).collect(Collectors.toList());
    }

    public void addTask(BasicTask task) {
        TaskDependency pre = null;
        TaskDependency t = new TaskDependency(task);
        pre = this.tasksMap.putIfAbsent(task.getName(), t);
        if (pre != null) {
            throw new IllegalStateException("name:" + task.getName() + " has exist");
        }
    }
}

