/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.taskflow;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.qlangtech.tis.fullbuild.taskflow.BasicTask;
import com.qlangtech.tis.fullbuild.taskflow.TaskWorkflow;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class TaskDependency {
    private final BasicTask task;
    private final Map<String, AtomicBoolean> precondition = Maps.newHashMap();

    public TaskDependency(BasicTask task) {
        this.task = task;
    }

    public int getPreconditionCount() {
        return this.precondition.size();
    }

    public String getPrecondition() {
        return Joiner.on((String)",").join(this.precondition.keySet());
    }

    public void init(TaskWorkflow workflow) {
        for (BasicTask t : workflow.getAllTask()) {
            String[] tos = StringUtils.split((String)t.getSuccessTo(), (String)",");
            if (tos == null) continue;
            for (String to : tos) {
                if (!StringUtils.equals((CharSequence)this.task.getName(), (CharSequence)to)) continue;
                this.precondition.put(t.getName(), new AtomicBoolean(false));
            }
        }
    }

    public synchronized boolean isAllSatisfaction() {
        for (AtomicBoolean satisfaction : this.precondition.values()) {
            if (satisfaction.get()) continue;
            return false;
        }
        return true;
    }

    public synchronized void satisfaction(String preConditionTaskName) {
        AtomicBoolean pre = this.precondition.get(preConditionTaskName);
        if (pre == null) {
            throw new IllegalStateException("task " + preConditionTaskName + " is not the pre condition of " + this.task.getName());
        }
        pre.set(true);
    }

    public boolean exexute(Map<String, Object> params) {
        if (!this.isAllSatisfaction()) {
            return false;
        }
        this.task.exexute(params);
        System.out.println("===========task:" + this.task.getName() + " successful");
        return true;
    }

    public synchronized void addPrecondition(String taskName) {
        this.precondition.put(taskName, new AtomicBoolean(false));
    }

    public BasicTask getTask() {
        return this.task;
    }
}

