/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.servlet.impl;

import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.order.center.IParamContext;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExecContext
implements IParamContext {
    private static final Logger logger = LoggerFactory.getLogger(HttpExecContext.class);
    private final Map<String, String> params;

    public ExecutePhaseRange getExecutePhaseRange() {
        throw new UnsupportedOperationException();
    }

    public HttpExecContext(HttpServletRequest request, Map<String, String> params, boolean parseHeaders) {
        this.params = params;
        String key = null;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            key = String.valueOf(en.nextElement());
            if (params.containsKey(key)) continue;
            params.put(key, request.getParameter(key));
        }
        if (parseHeaders) {
            String headKeyName = null;
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                headKeyName = (String)headerNames.nextElement();
                params.put(headKeyName, request.getHeader(headKeyName));
            }
        }
    }

    public HttpExecContext(HttpServletRequest request) {
        this(request, new HashMap<String, String>(), false);
    }

    public String getString(String key) {
        String value = this.params.get(key);
        return value;
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public int getInt(String key) {
        String val = this.getString(key);
        if (StringUtils.isEmpty((String)val)) {
            throw new IllegalArgumentException("key:" + key + " relevant val in request.params can not be find");
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("key:" + key, e);
        }
    }

    public long getLong(String key) {
        try {
            return Long.parseLong(this.getString(key));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("key:" + key, e);
        }
    }

    public long getPartitionTimestampWithMillis() {
        throw new UnsupportedOperationException();
    }
}

