/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.servlet;

import com.google.common.collect.Maps;
import com.qlangtech.tis.exec.ExecuteResult;
import com.qlangtech.tis.exec.impl.DefaultChainContext;
import com.qlangtech.tis.exec.impl.TrackableExecuteInterceptor;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.servlet.ExecuteLock;
import com.qlangtech.tis.fullbuild.servlet.IRebindableMDC;
import com.qlangtech.tis.fullbuild.servlet.impl.HttpExecContext;
import com.qlangtech.tis.job.common.JobCommon;
import com.qlangtech.tis.order.center.IndexSwapTaskflowLauncher;
import com.qlangtech.tis.rpc.server.IncrStatusUmbilicalProtocolImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TisServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(TisServlet.class);
    private static final long serialVersionUID = 1L;
    private IndexSwapTaskflowLauncher indexSwapTaskflowLauncher;
    static final ExecutorService executeService = Executors.newCachedThreadPool(new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("triggerTask#" + this.index++);
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            });
            return t;
        }
    });
    static final Map<String, ExecuteLock> idles = new HashMap<String, ExecuteLock>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.indexSwapTaskflowLauncher = IndexSwapTaskflowLauncher.getIndexSwapTaskflowLauncher(config.getServletContext());
        logger.info("synchronize Plugins FromRemoteRepository success");
    }

    protected boolean isValidParams(HttpExecContext execContext, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        return true;
    }

    protected boolean shallValidateCollectionExist() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpExecContext execContext = new HttpExecContext(req, Maps.newHashMap(), true);
        int taskId = execContext.getInt("taskid");
        boolean asynJob = execContext.getBoolean("asynJobName");
        String appName = execContext.getString("appname");
        logger.info("receive a processing job CANCEL signal,taskId:{},asynJob:{},appName:{}", new Object[]{taskId, asynJob, appName});
        if (asynJob) {
            IncrStatusUmbilicalProtocolImpl incrController = IncrStatusUmbilicalProtocolImpl.getInstance();
            incrController.stop(appName);
        } else {
            Map.Entry<String, ExecuteLock> targetExecLock = null;
            TisServlet tisServlet = this;
            synchronized (tisServlet) {
                for (Map.Entry<String, ExecuteLock> execLock : idles.entrySet()) {
                    if (!execLock.getValue().matchTask(taskId)) continue;
                    targetExecLock = execLock;
                }
                if (targetExecLock == null) {
                    this.writeResult(false, "\u4efb\u52a1\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u7ec8\u6b62", (ServletResponse)resp, new KV[0]);
                    return;
                }
                ((ExecuteLock)targetExecLock.getValue()).cancelAllFuture();
                ((ExecuteLock)targetExecLock.getValue()).clearLockFutureQueue();
            }
        }
        PhaseStatusCollection phaseStatusCollection = TrackableExecuteInterceptor.getTaskPhaseReference(taskId);
        if (phaseStatusCollection != null) {
            phaseStatusCollection.flushStatus2Local();
        }
        this.writeResult(true, null, (ServletResponse)resp, new KV("taskid", String.valueOf(taskId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpExecContext execContext = this.createHttpExecContext(req);
        MDCParamContext mdcContext = this.getMDCParam(execContext, res);
        try {
            if (!this.isValidParams(execContext, req, res)) {
                return;
            }
            if (!mdcContext.validateParam()) {
                return;
            }
            ExecuteLock lock = mdcContext.getExecLock();
            CountDownLatch countDown = new CountDownLatch(1);
            DefaultChainContext chainContext = new DefaultChainContext(execContext);
            chainContext.setMdcParamContext(mdcContext);
            chainContext.setAppSourcePipelineController(IncrStatusUmbilicalProtocolImpl.getInstance());
            ExecuteLock.TaskFuture future = new ExecuteLock.TaskFuture(chainContext);
            future.setFuture(executeService.submit(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }));
            mdcContext.getExecLock().addTaskFuture(future);
            try {
                countDown.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            mdcContext.removeParam();
        }
    }

    private MDCParamContext getMDCParam(HttpExecContext execContext, HttpServletResponse res) {
        String indexName = execContext.getString("appname");
        if (StringUtils.isNotEmpty((String)indexName)) {
            MDC.put((String)"app", (String)indexName);
            return new DataXMDCParamContext(indexName, res);
        }
        Long wfid = execContext.getLong("workflow_id");
        MDC.put((String)"workflow_id", (String)String.valueOf(wfid));
        return new JustDataFlowMDCParamContext(wfid, res);
    }

    protected Logger getLog() {
        return logger;
    }

    protected ExecuteResult startWork(DefaultChainContext chainContext) throws Exception {
        return this.indexSwapTaskflowLauncher.startWork(chainContext);
    }

    protected HttpExecContext createHttpExecContext(HttpServletRequest req) {
        return new HttpExecContext(req);
    }

    protected void writeResult(boolean success, String msg, ServletResponse res, KV ... kvs) throws ServletException {
        res.setContentType("text/json");
        try {
            JSONObject json = new JSONObject();
            json.put("success", success);
            if (StringUtils.isNotBlank((String)msg)) {
                json.put("msg", (Object)msg);
            }
            if (kvs != null) {
                JSONObject kvjson = new JSONObject();
                for (KV kv : kvs) {
                    kvjson.put(kv.key, (Object)kv.value);
                }
                json.put("biz", (Object)kvjson);
            }
            res.getWriter().write(json.toString(1));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static class KV {
        private final String key;
        private final String value;

        public KV(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private class DataXMDCParamContext
    extends FullPhraseMDCParamContext {
        public DataXMDCParamContext(String dataxName, HttpServletResponse res) {
            super(dataxName, res);
        }

        @Override
        boolean validateParam() throws ServletException {
            return true;
        }
    }

    private class FullPhraseMDCParamContext
    extends MDCParamContext {
        private final String indexName;

        public FullPhraseMDCParamContext(String indexName, HttpServletResponse res) {
            super(res);
            this.indexName = indexName;
        }

        @Override
        protected String getExecLockKey() {
            return this.indexName;
        }

        private String getIndexName() {
            return this.indexName;
        }

        @Override
        void removeParam() {
            MDC.remove((String)"app");
            MDC.remove((String)"workflow_id");
        }

        @Override
        void resetParam(Integer taskid) {
            super.resetParam(taskid);
            MDC.put((String)"app", (String)this.indexName);
        }

        @Override
        boolean validateParam() throws ServletException {
            if (TisServlet.this.shallValidateCollectionExist()) {
                String msg = "indexName:" + this.indexName + " is not acceptable";
                TisServlet.this.writeResult(false, msg, (ServletResponse)this.res, new KV[0]);
                return false;
            }
            return true;
        }
    }

    private class JustDataFlowMDCParamContext
    extends MDCParamContext {
        private final Long workflowId;

        public JustDataFlowMDCParamContext(Long workflowId, HttpServletResponse res) {
            super(res);
            this.workflowId = workflowId;
        }

        @Override
        protected String getExecLockKey() {
            return "workflow_id-" + this.getWorkflowId();
        }

        @Override
        void removeParam() {
            MDC.remove((String)"app");
            MDC.remove((String)"workflow_id");
        }

        @Override
        boolean validateParam() {
            return true;
        }

        @Override
        void resetParam(Integer taskid) {
            super.resetParam(taskid);
            MDC.put((String)"workflow_id", (String)String.valueOf(this.getWorkflowId()));
        }

        private Long getWorkflowId() {
            return this.workflowId;
        }
    }

    private abstract class MDCParamContext
    implements IRebindableMDC {
        protected final HttpServletResponse res;
        Integer taskid;

        public MDCParamContext(HttpServletResponse res) {
            this.res = res;
        }

        abstract boolean validateParam() throws ServletException;

        protected abstract String getExecLockKey();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final ExecuteLock getExecLock() {
            ExecuteLock lock = idles.get(this.getExecLockKey());
            if (lock != null) return lock;
            Class<TisServlet> clazz = TisServlet.class;
            synchronized (TisServlet.class) {
                lock = idles.get(this.getExecLockKey());
                if (lock != null) return lock;
                lock = new ExecuteLock(this.getExecLockKey());
                idles.put(this.getExecLockKey(), lock);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return lock;
            }
        }

        void resetParam(Integer taskid) {
            if (taskid == null || taskid < 1) {
                throw new IllegalArgumentException("param taskid can not be empty");
            }
            this.taskid = taskid;
            JobCommon.setMDC((int)taskid);
        }

        @Override
        public void rebind() {
            this.resetParam(this.taskid);
        }

        abstract void removeParam();
    }
}

