/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.servlet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.exec.impl.TrackableExecuteInterceptor;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TaskStatusServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String extendPoint = null;
        try {
            extendPoint = req.getParameter("extendPoint");
            if (StringUtils.isNotEmpty((String)extendPoint)) {
                int removeCount = TIS.cleanPluginStore(Class.forName(extendPoint));
                logger.info("key of '{}' pluginStore has been clean,remove count:{}", (Object)extendPoint, (Object)removeCount);
                return;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("clean plugin store cache faild ", (Throwable)e);
        }
        int taskid = Integer.parseInt(req.getParameter("taskid"));
        PhaseStatusCollection statusSet = TrackableExecuteInterceptor.getTaskPhaseReference(taskid);
        JSONObject result = new JSONObject();
        boolean success = false;
        if (statusSet != null) {
            result.put("status", (Object)statusSet);
            success = true;
        }
        result.put("success", (Object)success);
        IOUtils.write((String)JSON.toJSONString((Object)result, (boolean)true), (Writer)res.getWriter());
    }
}

