/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.servlet;

import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.fullbuild.servlet.TisServlet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteLock {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteLock.class);
    private final Queue<TaskFuture<?>> futureQueue = new ConcurrentLinkedQueue();
    private final AtomicBoolean lock = new AtomicBoolean(false);
    private AtomicLong startTimestamp;
    private static final long EXPIR_TIME = 32400000L;
    private final String taskOwnerUniqueName;

    public ExecuteLock(String indexName) {
        this.taskOwnerUniqueName = indexName;
        this.startTimestamp = new AtomicLong(System.currentTimeMillis());
    }

    public boolean matchTask(int taskId) {
        for (TaskFuture taskFuture : this.futureQueue) {
            if (taskFuture.taskId == null || taskFuture.taskId != taskId) continue;
            return true;
        }
        return false;
    }

    public void cancelAllFuture() {
        for (TaskFuture taskFuture : this.futureQueue) {
            try {
                taskFuture.cancelTask();
                taskFuture.future.cancel(true);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addTaskFuture(TaskFuture future) {
        this.futureQueue.add(future);
    }

    public String getTaskOwnerUniqueName() {
        return this.taskOwnerUniqueName;
    }

    boolean isExpire() {
        long now;
        boolean expire;
        long start = this.startTimestamp.get();
        boolean bl = expire = start + 32400000L < (now = System.currentTimeMillis());
        if (expire) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            logger.info("time:" + format.format(new Date(start)) + "is expire");
        }
        return expire;
    }

    public boolean lock() {
        if (this.lock.compareAndSet(false, true)) {
            this.startTimestamp.getAndSet(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public void unlock() {
        this.lock.lazySet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLockFutureQueue() {
        Class<TisServlet> clazz = TisServlet.class;
        synchronized (TisServlet.class) {
            this.unlock();
            this.futureQueue.clear();
            TisServlet.idles.remove(this.taskOwnerUniqueName, this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static class TaskFuture<T> {
        private Integer taskId;
        private Future<T> future;
        private IExecChainContext execChainContext;

        public TaskFuture(IExecChainContext execChainContext) {
            this.execChainContext = execChainContext;
        }

        public void cancelTask() {
            this.execChainContext.cancelTask();
        }

        public Future<T> getFuture() {
            return this.future;
        }

        public void setFuture(Future<T> future) {
            this.future = future;
        }

        public Integer getTaskId() {
            return this.taskId;
        }

        public void setTaskId(Integer taskId) {
            this.taskId = taskId;
        }
    }
}

