/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.servlet;

import com.qlangtech.tis.fullbuild.servlet.TisServlet;
import com.qlangtech.tis.fullbuild.servlet.impl.HttpExecContext;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildTriggerServlet
extends TisServlet {
    private static final long serialVersionUID = 1L;
    private static final String KEY_INDEX_NAME = "indexname";
    public static final String KEY_COLS = "cols";
    private static final String KEY_DUMP_START = "dumpstart";
    public static final String KEY_DUMP_ROW_COUNT = "rowcount";
    private static final Logger logger = LoggerFactory.getLogger(BuildTriggerServlet.class);

    @Override
    protected boolean isValidParams(HttpExecContext execContext, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        logger.info("requestURI:" + req.getRequestURL().append("?").append(req.getQueryString()));
        String clos = req.getParameter(KEY_COLS);
        String hdfspath = req.getParameter("hdfspath");
        String dumpstart = req.getParameter(KEY_DUMP_START);
        String paramsSign = req.getParameter("params_sign");
        String rowcount = req.getParameter(KEY_DUMP_ROW_COUNT);
        String indexname = execContext.getString("appname");
        if (StringUtils.isBlank((CharSequence)indexname)) {
            this.writeResult(false, "one of param indexname is blank", (ServletResponse)res, new TisServlet.KV[0]);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)clos)) {
            this.writeResult(false, "one of param clos is blank", (ServletResponse)res, new TisServlet.KV[0]);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)hdfspath)) {
            this.writeResult(false, "one of param hdfspath is blank", (ServletResponse)res, new TisServlet.KV[0]);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dumpstart)) {
            this.writeResult(false, "one of param dumpstart is blank", (ServletResponse)res, new TisServlet.KV[0]);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)paramsSign)) {
            this.writeResult(false, "one of param paramsSign is blank", (ServletResponse)res, new TisServlet.KV[0]);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)rowcount)) {
            this.writeResult(false, "one of param rowcount is blank", (ServletResponse)res, new TisServlet.KV[0]);
            return false;
        }
        String md5 = DigestUtils.md5Hex((String)(indexname + clos + hdfspath + dumpstart + rowcount));
        logger.info("param indexname:" + indexname + "\nclos:" + clos + "\n hdfspath:" + hdfspath + "\n dumpstart:" + dumpstart + "\n paramsSign:" + paramsSign + "\n rowcount:" + rowcount);
        return true;
    }

    @Override
    protected HttpExecContext createHttpExecContext(HttpServletRequest req) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appname", req.getParameter(KEY_INDEX_NAME));
        params.put("directbuild", Boolean.TRUE.toString());
        params.put("ps", req.getParameter(KEY_DUMP_START));
        params.put(KEY_DUMP_ROW_COUNT, req.getParameter(KEY_DUMP_ROW_COUNT));
        String hdfsSplitChar = null;
        hdfsSplitChar = req.getParameter("split_char");
        if (hdfsSplitChar != null) {
            params.put("split_char", hdfsSplitChar);
        }
        HttpExecContext execContext = new HttpExecContext(req, params, false);
        return execContext;
    }
}

