/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec.impl;

import com.qlangtech.tis.ajax.AjaxResult;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.exec.ActionInvocation;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.exec.ExecuteResult;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.exec.IExecuteInterceptor;
import com.qlangtech.tis.exec.ITaskPhaseInfo;
import com.qlangtech.tis.exec.datax.DataXAssembleSvcCompsite;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BasicPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.realtime.yarn.rpc.IncrStatusUmbilicalProtocol;
import com.qlangtech.tis.realtime.yarn.rpc.impl.AdapterStatusUmbilicalProtocol;
import com.qlangtech.tis.rpc.server.IncrStatusUmbilicalProtocolImpl;
import com.tis.hadoop.rpc.ITISRpcService;
import com.tis.hadoop.rpc.RpcServiceReference;
import com.tis.hadoop.rpc.StatusRpcClientFactory;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrackableExecuteInterceptor
implements IExecuteInterceptor,
ITaskPhaseInfo {
    private static final Logger log = LoggerFactory.getLogger(TrackableExecuteInterceptor.class);
    private static final Map<Integer, PhaseStatusCollection> taskPhaseReference = new WeakHashMap<Integer, PhaseStatusCollection>();

    public static PhaseStatusCollection initialTaskPhase(Integer taskid) {
        PhaseStatusCollection statusCollection = new PhaseStatusCollection(taskid, ExecutePhaseRange.fullRange());
        return TrackableExecuteInterceptor.initialTaskPhase(statusCollection);
    }

    public static PhaseStatusCollection initialTaskPhase(PhaseStatusCollection statusCollection) {
        taskPhaseReference.put(statusCollection.getTaskid(), statusCollection);
        return statusCollection;
    }

    public static PhaseStatusCollection getTaskPhaseReference(Integer taskId) {
        PhaseStatusCollection status = taskPhaseReference.get(taskId);
        return status;
    }

    protected RpcServiceReference getDataXExecReporter() {
        final IncrStatusUmbilicalProtocolImpl statusServer = IncrStatusUmbilicalProtocolImpl.getInstance();
        AdapterStatusUmbilicalProtocol statReceiveSvc = new AdapterStatusUmbilicalProtocol(){

            public void reportDumpTableStatus(DumpPhaseStatus.TableDumpStatus tableDumpStatus) {
                statusServer.reportDumpTableStatus(tableDumpStatus);
            }
        };
        AtomicReference<DataXAssembleSvcCompsite> ref = new AtomicReference<DataXAssembleSvcCompsite>();
        ref.set(new DataXAssembleSvcCompsite((IncrStatusUmbilicalProtocol)statReceiveSvc));
        return new RpcServiceReference(ref, (ITISRpcService)StatusRpcClientFactory.AssembleSvcCompsite.MOCK_PRC, () -> {});
    }

    public <T extends BasicPhaseStatus<?>> T getPhaseStatus(IExecChainContext execContext, FullbuildPhase phase) {
        PhaseStatusCollection phaseStatusCollection = taskPhaseReference.get(execContext.getTaskId());
        Objects.requireNonNull(phaseStatusCollection, "phaseStatusCollection can not be null");
        switch (phase) {
            case FullDump: {
                return (T)phaseStatusCollection.getDumpPhase();
            }
            case JOIN: {
                return (T)phaseStatusCollection.getJoinPhase();
            }
            case BUILD: {
                return (T)phaseStatusCollection.getBuildPhase();
            }
            case IndexBackFlow: {
                return (T)phaseStatusCollection.getIndexBackFlowPhaseStatus();
            }
        }
        throw new IllegalStateException(phase + " is illegal has not any match status");
    }

    @Override
    public final ExecuteResult intercept(ActionInvocation invocation) throws Exception {
        IExecChainContext execChainContext = invocation.getContext();
        int taskid = execChainContext.getTaskId();
        log.info("phase:" + FullbuildPhase.desc(this.getPhase()) + " start ,taskid:" + taskid);
        ExecuteResult result = null;
        result = this.execute(execChainContext);
        if (!result.isSuccess()) {
            log.error("taskid:" + taskid + ",phase:" + FullbuildPhase.desc(this.getPhase()) + " faild,reason:" + result.getMessage());
        }
        if (result.isSuccess()) {
            return invocation.invoke();
        }
        log.error("full build job is failed");
        return result;
    }

    protected abstract ExecuteResult execute(IExecChainContext var1) throws Exception;

    public static class CreateNewTaskResult {
        private int taskid;
        private Application app;

        public int getTaskid() {
            return this.taskid;
        }

        public void setTaskid(int taskid) {
            this.taskid = taskid;
        }

        public void setApp(Application app) {
            this.app = app;
        }

        public Application getApp() {
            return this.app;
        }
    }

    public static class IntegerAjaxResult
    extends AjaxResult<Integer> {
    }
}

