/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.datax.DataXJobSubmitParams;
import com.qlangtech.tis.datax.IDataXBatchPost;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.exec.ExecChainContextUtils;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.fs.ITISFileSystem;
import com.qlangtech.tis.fullbuild.indexbuild.RemoteTaskTriggers;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.servlet.IRebindableMDC;
import com.qlangtech.tis.offline.DataxUtils;
import com.qlangtech.tis.order.center.IAppSourcePipelineController;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.order.center.IndexSwapTaskflowLauncher;
import com.qlangtech.tis.sql.parser.TabPartitions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;

public class DefaultChainContext
implements IExecChainContext {
    private final long ps;
    private Optional<Integer> latestWFSuccessTaskId = Optional.empty();
    private ITISCoordinator zkClient;
    private ITISFileSystem indexBuildFileSystem;
    private final IParamContext httpExecContext;
    private ExecutePhaseRange executePhaseRange;
    private IRebindableMDC mdcParamContext;
    private IAppSourcePipelineController appSourcePipelineController;
    public final List<IExecChainContext.AsynSubJob> asynSubJobs = Lists.newCopyOnWriteArrayList();
    private RemoteTaskTriggers tskTriggers;
    private IDataxProcessor appSource;
    private final Map<String, Object> attribute = new HashMap<String, Object>();

    public DefaultChainContext(IParamContext execContext) {
        this.ps = DataxUtils.currentTimeStamp();
        this.httpExecContext = execContext;
        String latestWorkflowHistoryId = execContext.getString("latest_workflow_history_id");
        if (StringUtils.isNotEmpty((String)latestWorkflowHistoryId)) {
            this.setLatestWFSuccessTaskId(Integer.parseInt(latestWorkflowHistoryId));
        }
        ExecChainContextUtils.setDependencyTablesPartitions((IJoinTaskContext)this, (TabPartitions)new TabPartitions((Map)Maps.newHashMap()));
    }

    public String getJavaMemSpec() {
        DataXJobSubmitParams submitParams = DataXJobSubmitParams.getDftIfEmpty();
        return submitParams.getJavaMemorySpec();
    }

    public void setLatestWFSuccessTaskId(Integer latestWFSuccessTaskId) {
        this.latestWFSuccessTaskId = Optional.of(latestWFSuccessTaskId);
    }

    public void cancelTask() {
        int tryCount = 0;
        while (tryCount++ < 4) {
            if (this.tskTriggers != null) {
                this.tskTriggers.allCancel();
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void setTskTriggers(RemoteTaskTriggers tskTriggers) {
        this.tskTriggers = tskTriggers;
    }

    public RemoteTaskTriggers getTskTriggers() {
        return this.tskTriggers;
    }

    public List<IExecChainContext.AsynSubJob> getAsynSubJobs() {
        return this.asynSubJobs;
    }

    public void addAsynSubJob(IExecChainContext.AsynSubJob jobName) {
        this.asynSubJobs.add(jobName);
    }

    public boolean containAsynJob() {
        return !this.asynSubJobs.isEmpty();
    }

    public int getTaskId() {
        Integer taskid = (Integer)this.getAttribute("taskid");
        Objects.requireNonNull(taskid, "taskid can not be null");
        return taskid;
    }

    public boolean isDryRun() {
        return this.httpExecContext.getBoolean("dryRun");
    }

    public void setMdcParamContext(IRebindableMDC mdcParamContext) {
        this.mdcParamContext = mdcParamContext;
    }

    public int getIndexShardCount() {
        try {
            return this.getInt("index_shard_count");
        }
        catch (Exception e) {
            throw new RuntimeException("index_shard_count is illegal", e);
        }
    }

    public void rebindLoggingMDCParams() {
        if (this.mdcParamContext == null) {
            throw new IllegalStateException("must execute method 'setMdcParamContext'");
        }
        this.mdcParamContext.rebind();
    }

    public ExecutePhaseRange getExecutePhaseRange() {
        if (this.executePhaseRange == null) {
            String start = this.getString("component.start");
            if (StringUtils.isNotEmpty((String)start)) {
                String end = StringUtils.defaultIfEmpty((String)this.getString("component.end"), (String)FullbuildPhase.IndexBackFlow.getName());
                this.executePhaseRange = new ExecutePhaseRange(FullbuildPhase.parse((String)start), FullbuildPhase.parse((String)end));
            } else {
                IDataxProcessor appSource = this.getProcessor();
                IDataxWriter writer = appSource.getWriter(null, true);
                this.executePhaseRange = writer instanceof IDataXBatchPost ? ((IDataXBatchPost)writer).getPhaseRange() : new ExecutePhaseRange(FullbuildPhase.FullDump, FullbuildPhase.FullDump);
            }
        }
        return this.executePhaseRange;
    }

    private void setIndexBuildFileSystem(ITISFileSystem fileSystem) {
        Objects.requireNonNull(fileSystem, "indexBuild fileSystem can not be null");
        this.indexBuildFileSystem = fileSystem;
    }

    public Integer getWorkflowId() {
        try {
            return Integer.parseInt(this.getString("workflow_id"));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getWorkflowName() {
        String result = this.getString("workflow_name");
        if (StringUtils.isEmpty((String)result)) {
            throw new IllegalStateException("workflow_name can not be empty");
        }
        return result;
    }

    public IDataxProcessor getProcessor() {
        if (this.appSource == null) {
            StoreResourceType resType = null;
            String targetName = null;
            if (!this.hasIndexName() && this.getWorkflowId() != null) {
                resType = StoreResourceType.DataFlow;
                targetName = this.getWorkflowName();
            } else if (this.hasIndexName()) {
                resType = StoreResourceType.DataApp;
                targetName = this.getIndexName();
            } else {
                throw new UnsupportedOperationException();
            }
            this.appSource = DataxProcessor.load(null, (StoreResourceType)resType, (String)targetName);
        }
        return this.appSource;
    }

    public void setAttribute(String key, Object v) {
        this.attribute.put(key, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAttribute(String key, Supplier<T> creator) {
        Map<String, Object> map = this.attribute;
        synchronized (map) {
            T attr = this.getAttribute(key);
            if (attr == null) {
                attr = creator.get();
                this.setAttribute(key, attr);
            }
            return attr;
        }
    }

    public <T> T getAttribute(String key) {
        return (T)this.attribute.get(key);
    }

    public ITISCoordinator getZkClient() {
        if (this.zkClient == null) {
            throw new NullPointerException("zkClient can not null");
        }
        return this.zkClient;
    }

    public void setZkClient(ITISCoordinator zkClient) {
        this.zkClient = zkClient;
    }

    public ITISFileSystem getIndexBuildFileSystem() {
        return this.indexBuildFileSystem;
    }

    public boolean hasIndexName() {
        String indexName = this.httpExecContext.getString("appname");
        return StringUtils.isNotBlank((String)indexName);
    }

    public String getIndexName() {
        String indexName = this.httpExecContext.getString("appname");
        if (StringUtils.isBlank((String)indexName)) {
            throw new IllegalArgumentException(indexName);
        }
        return indexName;
    }

    public long getPartitionTimestampWithMillis() {
        return this.ps;
    }

    public String getString(String key) {
        return this.httpExecContext.getString(key);
    }

    public boolean getBoolean(String key) {
        return this.httpExecContext.getBoolean(key);
    }

    public int getInt(String key) {
        return this.httpExecContext.getInt(key);
    }

    public long getLong(String key) {
        return this.httpExecContext.getLong(key);
    }

    public IAppSourcePipelineController getPipelineController() {
        Objects.requireNonNull(this.appSourcePipelineController, "appSourcePipelineController can not be null");
        return this.appSourcePipelineController;
    }

    public void setAppSourcePipelineController(IAppSourcePipelineController appSourcePipelineController) {
        this.appSourcePipelineController = appSourcePipelineController;
    }

    public PhaseStatusCollection loadPhaseStatusFromLatest() {
        return DefaultChainContext.loadPhaseStatusFromLatest(this.latestWFSuccessTaskId);
    }

    public static PhaseStatusCollection loadPhaseStatusFromLatest(Optional<Integer> latestWFSuccessTaskId) {
        return latestWFSuccessTaskId.map(historyId -> IndexSwapTaskflowLauncher.loadPhaseStatusFromLocal(historyId)).orElse(null);
    }
}

