/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec.datax;

import com.google.common.collect.Sets;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.impl.DataXCfgGenerator;
import com.qlangtech.tis.exec.ExecuteResult;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.exec.ITaskPhaseInfo;
import com.qlangtech.tis.exec.impl.TrackableExecuteInterceptor;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskTrigger;
import com.qlangtech.tis.fullbuild.indexbuild.RemoteTaskTriggers;
import com.qlangtech.tis.fullbuild.taskflow.TISReactor;
import com.qlangtech.tis.fullbuild.taskflow.TaskAndMilestone;
import com.qlangtech.tis.manage.common.DagTaskUtils;
import com.qlangtech.tis.manage.impl.DataFlowAppSource;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.plugin.trigger.JobTrigger;
import com.qlangtech.tis.powerjob.IDAGSessionSpec;
import com.qlangtech.tis.sql.parser.DAGSessionSpec;
import com.qlangtech.tis.util.IPluginContext;
import com.tis.hadoop.rpc.RpcServiceReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jvnet.hudson.reactor.ReactorListener;
import org.jvnet.hudson.reactor.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataXExecuteInterceptor
extends TrackableExecuteInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DataXExecuteInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExecuteResult execute(final IExecChainContext execChainContext) throws Exception {
        RpcServiceReference statusRpc = this.getDataXExecReporter();
        IDataxProcessor appSource = execChainContext.getProcessor();
        DataXJobSubmit.InstanceType expectDataXJobSumit = this.getDataXTriggerType();
        Optional jobSubmit = DataXJobSubmit.getDataXJobSubmit((IJoinTaskContext)execChainContext, (DataXJobSubmit.InstanceType)expectDataXJobSumit);
        if (!jobSubmit.isPresent()) {
            throw new IllegalStateException("can not find expect jobSubmit by type:" + expectDataXJobSumit);
        }
        DataXJobSubmit submit = (DataXJobSubmit)jobSubmit.get();
        ExecutorService executorService = DataFlowAppSource.createExecutorService((IExecChainContext)execChainContext);
        RemoteTaskTriggers tskTriggers = new RemoteTaskTriggers(executorService);
        execChainContext.setTskTriggers(tskTriggers);
        DataXCfgGenerator.GenerateCfgs cfgFileNames = appSource.getDataxCfgFileNames(null, JobTrigger.getTriggerFromHttpParam((IParamContext)execChainContext));
        IPluginContext.setPluginContext((IPluginContext)IPluginContext.namedContext((DataXName)new DataXName(appSource.identityValue(), appSource.getResType())));
        DAGSessionSpec sessionSpec = (DAGSessionSpec)DAGSessionSpec.createDAGSessionSpec((IExecChainContext)execChainContext, (RpcServiceReference)statusRpc, (IDataxProcessor)appSource, (DataXCfgGenerator.GenerateCfgs)cfgFileNames, (DataXJobSubmit)submit).getLeft();
        final List triggers = DagTaskUtils.createTasks((IExecChainContext)execChainContext, (ITaskPhaseInfo)this, (IDAGSessionSpec)sessionSpec, (RemoteTaskTriggers)tskTriggers);
        DataXJobSubmit.IDataXJobContext dataXJobContext = submit.createJobContext(execChainContext);
        Objects.requireNonNull(dataXJobContext, "dataXJobContext can not be null");
        try {
            StringBuffer dagSessionSpec = sessionSpec.buildSpec();
            logger.info("dataX:{} of dagSessionSpec:{}", (Object)execChainContext.getIndexName(), (Object)dagSessionSpec);
            final ExecuteResult[] faildResult = new ExecuteResult[]{ExecuteResult.createSuccess()};
            this.executeDAG(executorService, execChainContext, dagSessionSpec, sessionSpec.getTaskMap(), new ReactorListener(){

                public void onTaskCompleted(Task t) {
                }

                public void onTaskFailed(Task t, Throwable err, boolean fatal) {
                    logger.error(t.getDisplayName(), err);
                    faildResult[0] = ExecuteResult.createFaild().setMessage("status.runningStatus.isComplete():" + err.getMessage());
                    if (err instanceof InterruptedException) {
                        logger.warn("DataX Name:{},taskid:{} has been canceled", (Object)execChainContext.getIndexName(), (Object)execChainContext.getTaskId());
                        for (IRemoteTaskTrigger tt : triggers) {
                            try {
                                tt.cancel();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            });
            for (IRemoteTaskTrigger trigger : triggers) {
                if (!trigger.isAsyn()) continue;
                execChainContext.addAsynSubJob(new IExecChainContext.AsynSubJob(trigger.getAsynJobName()));
            }
            ExecuteResult executeResult = faildResult[0];
            return executeResult;
        }
        finally {
            try {
                dataXJobContext.destroy();
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
            executorService.shutdown();
        }
    }

    private void executeDAG(ExecutorService executorService, IExecChainContext execChainContext, StringBuffer dagSessionSpec, Map<String, TaskAndMilestone> taskMap, ReactorListener reactorListener) {
        try {
            TISReactor reactor = new TISReactor(execChainContext, taskMap);
            logger.info("dagSessionSpec:" + dagSessionSpec);
            reactor.execute((Executor)executorService, reactor.buildSession((CharSequence)dagSessionSpec), new ReactorListener[]{reactorListener});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DataXJobSubmit.InstanceType getDataXTriggerType() {
        return DataXJobSubmit.getDataXTriggerType();
    }

    @Override
    public Set<FullbuildPhase> getPhase() {
        return Sets.newHashSet((Object[])new FullbuildPhase[]{FullbuildPhase.FullDump, FullbuildPhase.JOIN});
    }
}

